/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.index.query;

import com.google.gerrit.index.query.OperatorPredicate;

public abstract class IntPredicate<T>
extends OperatorPredicate<T> {
    private final int intValue;

    public IntPredicate(String name, String value) {
        super(name, value);
        this.intValue = Integer.parseInt(value);
    }

    public IntPredicate(String name, int intValue) {
        super(name, String.valueOf(intValue));
        this.intValue = intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    @Override
    public int hashCode() {
        return this.getOperator().hashCode() * 31 + this.intValue;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() == other.getClass()) {
            IntPredicate p = (IntPredicate)other;
            return this.getOperator().equals(p.getOperator()) && this.intValue() == p.intValue();
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getOperator() + ":" + this.getValue();
    }
}

