/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.lucene;

import com.google.common.collect.Iterables;
import com.google.gerrit.index.FieldDef;
import com.google.gerrit.index.QueryOptions;
import com.google.gerrit.index.Schema;
import com.google.gerrit.index.query.DataSource;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gerrit.lucene.AbstractLuceneIndex;
import com.google.gerrit.lucene.GerritIndexWriterConfig;
import com.google.gerrit.lucene.LuceneChangeIndex;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.index.change.ChangeIndex;
import com.google.gerrit.server.query.change.ChangeData;
import java.io.IOException;
import java.nio.file.Path;
import java.sql.Timestamp;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class ChangeSubIndex
extends AbstractLuceneIndex<Change.Id, ChangeData>
implements ChangeIndex {
    ChangeSubIndex(Schema<ChangeData> schema, SitePaths sitePaths, Path path, GerritIndexWriterConfig writerConfig, SearcherFactory searcherFactory) throws IOException {
        this(schema, sitePaths, FSDirectory.open(path), path.getFileName().toString(), writerConfig, searcherFactory);
    }

    ChangeSubIndex(Schema<ChangeData> schema, SitePaths sitePaths, Directory dir, String subIndex, GerritIndexWriterConfig writerConfig, SearcherFactory searcherFactory) throws IOException {
        super(schema, sitePaths, dir, "changes", subIndex, writerConfig, searcherFactory);
    }

    @Override
    public void replace(ChangeData obj) throws IOException {
        throw new UnsupportedOperationException("don't use ChangeSubIndex directly");
    }

    @Override
    public void delete(Change.Id key) throws IOException {
        throw new UnsupportedOperationException("don't use ChangeSubIndex directly");
    }

    @Override
    public DataSource<ChangeData> getSource(Predicate<ChangeData> p, QueryOptions opts) throws QueryParseException {
        throw new UnsupportedOperationException("don't use ChangeSubIndex directly");
    }

    @Override
    void add(Document doc, Schema.Values<ChangeData> values) {
        FieldDef<ChangeData, ?> f = values.getField();
        if (f == ChangeField.LEGACY_ID) {
            int v = (Integer)Iterables.getOnlyElement(values.getValues());
            doc.add(new NumericDocValuesField(LuceneChangeIndex.ID_SORT_FIELD, v));
        } else if (f == ChangeField.UPDATED) {
            long t = ((Timestamp)Iterables.getOnlyElement(values.getValues())).getTime();
            doc.add(new NumericDocValuesField(LuceneChangeIndex.UPDATED_SORT_FIELD, t));
        }
        super.add(doc, values);
    }
}

