/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.metrics.dropwizard;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.google.gerrit.metrics.CallbackMetric0;
import com.google.gerrit.metrics.dropwizard.CallbackMetricGlue;
import com.google.gerrit.metrics.dropwizard.DropWizardMetricMaker;

class CallbackMetricImpl0<V>
extends CallbackMetric0<V>
implements CallbackMetricGlue {
    private final DropWizardMetricMaker metrics;
    private final MetricRegistry registry;
    private final String name;
    private volatile V value;

    static <V> V zeroFor(Class<V> valueClass) {
        if (valueClass == Integer.class) {
            return (V)Integer.valueOf(0);
        }
        if (valueClass == Long.class) {
            return (V)Long.valueOf(0L);
        }
        if (valueClass == Double.class) {
            return (V)Double.valueOf(0.0);
        }
        if (valueClass == Float.class) {
            return (V)Float.valueOf(0.0f);
        }
        if (valueClass == String.class) {
            return (V)"";
        }
        if (valueClass == Boolean.class) {
            return (V)Boolean.FALSE;
        }
        throw new IllegalArgumentException("unsupported value type " + valueClass.getName());
    }

    CallbackMetricImpl0(DropWizardMetricMaker metrics, MetricRegistry registry, String name, Class<V> valueType) {
        this.metrics = metrics;
        this.registry = registry;
        this.name = name;
        this.value = CallbackMetricImpl0.zeroFor(valueType);
    }

    @Override
    public void beginSet() {
    }

    @Override
    public void endSet() {
    }

    @Override
    public void set(V value) {
        this.value = value;
    }

    @Override
    public void remove() {
        this.metrics.remove(this.name);
        this.registry.remove(this.name);
    }

    @Override
    public void register(final Runnable trigger) {
        this.registry.register(this.name, new Gauge<V>(){

            @Override
            public V getValue() {
                trigger.run();
                return CallbackMetricImpl0.this.value;
            }
        });
    }
}

