/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestCollection;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountControl;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.CreateAccount;
import com.google.gerrit.server.account.QueryAccounts;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class AccountsCollection
implements RestCollection<TopLevelResource, AccountResource>,
AcceptsCreate<TopLevelResource> {
    private final Provider<CurrentUser> self;
    private final AccountResolver resolver;
    private final AccountControl.Factory accountControlFactory;
    private final IdentifiedUser.GenericFactory userFactory;
    private final Provider<QueryAccounts> list;
    private final DynamicMap<RestView<AccountResource>> views;
    private final CreateAccount.Factory createAccountFactory;

    @Inject
    AccountsCollection(Provider<CurrentUser> self, AccountResolver resolver, AccountControl.Factory accountControlFactory, IdentifiedUser.GenericFactory userFactory, Provider<QueryAccounts> list, DynamicMap<RestView<AccountResource>> views, CreateAccount.Factory createAccountFactory) {
        this.self = self;
        this.resolver = resolver;
        this.accountControlFactory = accountControlFactory;
        this.userFactory = userFactory;
        this.list = list;
        this.views = views;
        this.createAccountFactory = createAccountFactory;
    }

    @Override
    public AccountResource parse(TopLevelResource root, IdString id) throws ResourceNotFoundException, AuthException, OrmException, IOException, ConfigInvalidException {
        IdentifiedUser user = this.parseId(id.get());
        if (user == null) {
            throw new ResourceNotFoundException(id);
        }
        if (!this.accountControlFactory.get().canSee(user.getAccount())) {
            throw new ResourceNotFoundException(id);
        }
        return new AccountResource(user);
    }

    public IdentifiedUser parse(String id) throws AuthException, UnprocessableEntityException, OrmException, IOException, ConfigInvalidException {
        return this.parseOnBehalfOf(null, id);
    }

    public IdentifiedUser parseId(String id) throws AuthException, OrmException, IOException, ConfigInvalidException {
        return this.parseIdOnBehalfOf(null, id);
    }

    public IdentifiedUser parseOnBehalfOf(@Nullable CurrentUser caller, String id) throws AuthException, UnprocessableEntityException, OrmException, IOException, ConfigInvalidException {
        IdentifiedUser user = this.parseIdOnBehalfOf(caller, id);
        if (user == null) {
            throw new UnprocessableEntityException(String.format("Account Not Found: %s", id));
        }
        if (!this.accountControlFactory.get().canSee(user.getAccount())) {
            throw new UnprocessableEntityException(String.format("Account Not Found: %s", id));
        }
        return user;
    }

    private IdentifiedUser parseIdOnBehalfOf(@Nullable CurrentUser caller, String id) throws AuthException, OrmException, IOException, ConfigInvalidException {
        if (id.equals("self")) {
            CurrentUser user = this.self.get();
            if (user.isIdentifiedUser()) {
                return user.asIdentifiedUser();
            }
            if (user instanceof AnonymousUser) {
                throw new AuthException("Authentication required");
            }
            return null;
        }
        Account match = this.resolver.find(id);
        if (match == null) {
            return null;
        }
        CurrentUser realUser = caller != null ? caller.getRealUser() : null;
        return this.userFactory.runAs(null, match.getId(), realUser);
    }

    @Override
    public RestView<TopLevelResource> list() throws ResourceNotFoundException {
        return this.list.get();
    }

    @Override
    public DynamicMap<RestView<AccountResource>> views() {
        return this.views;
    }

    public CreateAccount create(TopLevelResource parent, IdString username) {
        return this.createAccountFactory.create(username.get());
    }
}

