/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

public interface EmailExpander {
    public boolean canExpand(String var1);

    public String expand(String var1);

    public static class Simple
    implements EmailExpander {
        private static final String PLACEHOLDER = "{0}";
        private final String lhs;
        private final String rhs;

        public static boolean canHandle(String fmt) {
            return fmt != null && fmt.contains(PLACEHOLDER);
        }

        public Simple(String fmt) {
            int p = fmt.indexOf(PLACEHOLDER);
            this.lhs = fmt.substring(0, p);
            this.rhs = fmt.substring(p + PLACEHOLDER.length());
        }

        @Override
        public boolean canExpand(String user) {
            return !user.contains(" ");
        }

        @Override
        public String expand(String user) {
            return this.lhs + user + this.rhs;
        }
    }

    public static class None
    implements EmailExpander {
        public static final None INSTANCE = new None();

        public static boolean canHandle(String fmt) {
            return fmt == null || fmt.isEmpty();
        }

        private None() {
        }

        @Override
        public boolean canExpand(String user) {
            return false;
        }

        @Override
        public String expand(String user) {
            return null;
        }
    }
}

