/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Ints;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.apache.commons.codec.DecoderException;
import org.bouncycastle.crypto.generators.BCrypt;
import org.bouncycastle.util.Arrays;

public class HashedPassword {
    private static final String ALGORITHM_PREFIX = "bcrypt:";
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final BaseEncoding codec = BaseEncoding.base64();
    private static final int DEFAULT_COST = 4;
    private byte[] salt;
    private byte[] hashed;
    private int cost;

    public static HashedPassword decode(String encoded) throws DecoderException {
        if (!encoded.startsWith(ALGORITHM_PREFIX)) {
            throw new DecoderException("unrecognized algorithm");
        }
        String[] fields = encoded.split(":");
        if (fields.length != 4) {
            throw new DecoderException("want 4 fields");
        }
        Integer cost = Ints.tryParse(fields[1]);
        if (cost == null) {
            throw new DecoderException("cost parse failed");
        }
        if (cost < 4 || cost >= 32) {
            throw new DecoderException("cost should be 4..31 inclusive, got " + cost);
        }
        byte[] salt = codec.decode(fields[2]);
        if (salt.length != 16) {
            throw new DecoderException("salt should be 16 bytes, got " + salt.length);
        }
        return new HashedPassword(codec.decode(fields[3]), salt, cost);
    }

    private static byte[] hashPassword(String password, byte[] salt, int cost) {
        byte[] pwBytes = password.getBytes(StandardCharsets.UTF_8);
        return BCrypt.generate((byte[])pwBytes, (byte[])salt, (int)cost);
    }

    public static HashedPassword fromPassword(String password) {
        byte[] salt = HashedPassword.newSalt();
        return new HashedPassword(HashedPassword.hashPassword(password, salt, 4), salt, 4);
    }

    private static byte[] newSalt() {
        byte[] bytes = new byte[16];
        secureRandom.nextBytes(bytes);
        return bytes;
    }

    private HashedPassword(byte[] hashed, byte[] salt, int cost) {
        this.salt = salt;
        this.hashed = hashed;
        this.cost = cost;
        Preconditions.checkState(cost >= 4 && cost < 32);
        Preconditions.checkState(salt.length == 16);
    }

    public String encode() {
        return ALGORITHM_PREFIX + this.cost + ":" + codec.encode(this.salt) + ":" + codec.encode(this.hashed);
    }

    public boolean checkPassword(String password) {
        return Arrays.areEqual((byte[])HashedPassword.hashPassword(password, this.salt, this.cost), (byte[])this.hashed);
    }
}

