/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.git.QueryList;
import com.google.gerrit.server.git.VersionedMetaData;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionedAccountQueries
extends VersionedMetaData {
    private static final Logger log = LoggerFactory.getLogger(VersionedAccountQueries.class);
    private final String ref;
    private QueryList queryList;

    public static VersionedAccountQueries forUser(Account.Id id) {
        return new VersionedAccountQueries(RefNames.refsUsers(id));
    }

    private VersionedAccountQueries(String ref) {
        this.ref = ref;
    }

    @Override
    protected String getRefName() {
        return this.ref;
    }

    public QueryList getQueryList() {
        return this.queryList;
    }

    @Override
    protected void onLoad() throws IOException, ConfigInvalidException {
        this.queryList = QueryList.parse(this.readUTF8("queries"), error -> log.error("Error parsing file {}: {}", (Object)"queries", (Object)error.getMessage()));
    }

    @Override
    protected boolean onSave(CommitBuilder commit) throws IOException, ConfigInvalidException {
        throw new UnsupportedOperationException("Cannot yet save named queries");
    }
}

