/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Enums;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AutoValue_WatchConfig_NotifyValue;
import com.google.gerrit.server.account.AutoValue_WatchConfig_ProjectWatchKey;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ValidationError;
import com.google.gerrit.server.git.VersionedMetaData;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;

public class WatchConfig
extends VersionedMetaData
implements ValidationError.Sink {
    public static final String FILTER_ALL = "*";
    public static final String WATCH_CONFIG = "watch.config";
    public static final String PROJECT = "project";
    public static final String KEY_NOTIFY = "notify";
    private final Account.Id accountId;
    private final String ref;
    private Map<ProjectWatchKey, Set<NotifyType>> projectWatches;
    private List<ValidationError> validationErrors;

    public WatchConfig(Account.Id accountId) {
        this.accountId = accountId;
        this.ref = RefNames.refsUsers(accountId);
    }

    @Override
    protected String getRefName() {
        return this.ref;
    }

    @Override
    protected void onLoad() throws IOException, ConfigInvalidException {
        Config cfg = this.readConfig(WATCH_CONFIG);
        this.projectWatches = WatchConfig.parse(this.accountId, cfg, this);
    }

    @VisibleForTesting
    public static Map<ProjectWatchKey, Set<NotifyType>> parse(Account.Id accountId, Config cfg, ValidationError.Sink validationErrorSink) {
        HashMap<ProjectWatchKey, Set<NotifyType>> projectWatches = new HashMap<ProjectWatchKey, Set<NotifyType>>();
        for (String projectName : cfg.getSubsections(PROJECT)) {
            String[] notifyValues;
            for (String nv : notifyValues = cfg.getStringList(PROJECT, projectName, KEY_NOTIFY)) {
                NotifyValue notifyValue;
                if (Strings.isNullOrEmpty(nv) || (notifyValue = NotifyValue.parse(accountId, projectName, nv, validationErrorSink)) == null) continue;
                ProjectWatchKey key = ProjectWatchKey.create(new Project.NameKey(projectName), notifyValue.filter());
                if (!projectWatches.containsKey(key)) {
                    projectWatches.put(key, EnumSet.noneOf(NotifyType.class));
                }
                ((Set)projectWatches.get(key)).addAll(notifyValue.notifyTypes());
            }
        }
        return projectWatches;
    }

    Map<ProjectWatchKey, Set<NotifyType>> getProjectWatches() {
        this.checkLoaded();
        return this.projectWatches;
    }

    public void setProjectWatches(Map<ProjectWatchKey, Set<NotifyType>> projectWatches) {
        this.projectWatches = projectWatches;
    }

    @Override
    protected boolean onSave(CommitBuilder commit) throws IOException, ConfigInvalidException {
        this.checkLoaded();
        if (Strings.isNullOrEmpty(commit.getMessage())) {
            commit.setMessage("Updated watch configuration\n");
        }
        Config cfg = this.readConfig(WATCH_CONFIG);
        for (String projectName : cfg.getSubsections(PROJECT)) {
            cfg.unsetSection(PROJECT, projectName);
        }
        Multimap notifyValuesByProject = MultimapBuilder.hashKeys().arrayListValues().build();
        for (Map.Entry<ProjectWatchKey, Set<NotifyType>> entry : this.projectWatches.entrySet()) {
            NotifyValue notifyValue = NotifyValue.create(entry.getKey().filter(), entry.getValue());
            notifyValuesByProject.put(entry.getKey().project().get(), notifyValue.toString());
        }
        for (Map.Entry<ProjectWatchKey, Collection<NotifyType>> entry : notifyValuesByProject.asMap().entrySet()) {
            cfg.setStringList(PROJECT, (String)((Object)entry.getKey()), KEY_NOTIFY, new ArrayList<NotifyType>(entry.getValue()));
        }
        this.saveConfig(WATCH_CONFIG, cfg);
        return true;
    }

    private void checkLoaded() {
        Preconditions.checkState(this.projectWatches != null, "project watches not loaded yet");
    }

    @Override
    public void error(ValidationError error) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>(4);
        }
        this.validationErrors.add(error);
    }

    public List<ValidationError> getValidationErrors() {
        if (this.validationErrors != null) {
            return ImmutableList.copyOf(this.validationErrors);
        }
        return ImmutableList.of();
    }

    @AutoValue
    public static abstract class NotifyValue {
        public static NotifyValue parse(Account.Id accountId, String project, String notifyValue, ValidationError.Sink validationErrorSink) {
            int i = (notifyValue = notifyValue.trim()).lastIndexOf(91);
            if (i < 0 || notifyValue.charAt(notifyValue.length() - 1) != ']') {
                validationErrorSink.error(new ValidationError(WatchConfig.WATCH_CONFIG, String.format("Invalid project watch of account %d for project %s: %s", accountId.get(), project, notifyValue)));
                return null;
            }
            String filter = notifyValue.substring(0, i).trim();
            if (filter.isEmpty() || WatchConfig.FILTER_ALL.equals(filter)) {
                filter = null;
            }
            EnumSet<NotifyType> notifyTypes = EnumSet.noneOf(NotifyType.class);
            if (i + 1 < notifyValue.length() - 2) {
                for (String nt : Splitter.on(',').trimResults().splitToList(notifyValue.substring(i + 1, notifyValue.length() - 1))) {
                    NotifyType notifyType = Enums.getIfPresent(NotifyType.class, nt).orNull();
                    if (notifyType == null) {
                        validationErrorSink.error(new ValidationError(WatchConfig.WATCH_CONFIG, String.format("Invalid notify type %s in project watch of account %d for project %s: %s", nt, accountId.get(), project, notifyValue)));
                        continue;
                    }
                    notifyTypes.add(notifyType);
                }
            }
            return NotifyValue.create(filter, notifyTypes);
        }

        public static NotifyValue create(@Nullable String filter, Set<NotifyType> notifyTypes) {
            return new AutoValue_WatchConfig_NotifyValue(Strings.emptyToNull(filter), Sets.immutableEnumSet(notifyTypes));
        }

        @Nullable
        public abstract String filter();

        public abstract ImmutableSet<NotifyType> notifyTypes();

        public String toString() {
            ArrayList<NotifyType> notifyTypes = new ArrayList<NotifyType>(this.notifyTypes());
            StringBuilder notifyValue = new StringBuilder();
            notifyValue.append(MoreObjects.firstNonNull(this.filter(), WatchConfig.FILTER_ALL)).append(" [");
            Joiner.on(", ").appendTo(notifyValue, (Iterable<?>)notifyTypes);
            notifyValue.append("]");
            return notifyValue.toString();
        }
    }

    public static enum NotifyType {
        ABANDONED_CHANGES,
        ALL_COMMENTS,
        NEW_CHANGES,
        NEW_PATCHSETS,
        SUBMITTED_CHANGES,
        ALL;

    }

    @AutoValue
    public static abstract class ProjectWatchKey {
        public static ProjectWatchKey create(Project.NameKey project, @Nullable String filter) {
            return new AutoValue_WatchConfig_ProjectWatchKey(project, Strings.emptyToNull(filter));
        }

        public abstract Project.NameKey project();

        @Nullable
        public abstract String filter();
    }

    @Singleton
    public static class Accessor {
        private final GitRepositoryManager repoManager;
        private final AllUsersName allUsersName;
        private final Provider<MetaDataUpdate.User> metaDataUpdateFactory;
        private final IdentifiedUser.GenericFactory userFactory;

        @Inject
        Accessor(GitRepositoryManager repoManager, AllUsersName allUsersName, Provider<MetaDataUpdate.User> metaDataUpdateFactory, IdentifiedUser.GenericFactory userFactory) {
            this.repoManager = repoManager;
            this.allUsersName = allUsersName;
            this.metaDataUpdateFactory = metaDataUpdateFactory;
            this.userFactory = userFactory;
        }

        public Map<ProjectWatchKey, Set<NotifyType>> getProjectWatches(Account.Id accountId) throws IOException, ConfigInvalidException {
            try (Repository git = this.repoManager.openRepository(this.allUsersName);){
                WatchConfig watchConfig = new WatchConfig(accountId);
                watchConfig.load(git);
                Map<ProjectWatchKey, Set<NotifyType>> map = watchConfig.getProjectWatches();
                return map;
            }
        }

        public synchronized void upsertProjectWatches(Account.Id accountId, Map<ProjectWatchKey, Set<NotifyType>> newProjectWatches) throws IOException, ConfigInvalidException {
            WatchConfig watchConfig = this.read(accountId);
            Map<ProjectWatchKey, Set<NotifyType>> projectWatches = watchConfig.getProjectWatches();
            projectWatches.putAll(newProjectWatches);
            this.commit(watchConfig);
        }

        public synchronized void deleteProjectWatches(Account.Id accountId, Collection<ProjectWatchKey> projectWatchKeys) throws IOException, ConfigInvalidException {
            WatchConfig watchConfig = this.read(accountId);
            Map<ProjectWatchKey, Set<NotifyType>> projectWatches = watchConfig.getProjectWatches();
            boolean commit = false;
            for (ProjectWatchKey key : projectWatchKeys) {
                if (projectWatches.remove(key) == null) continue;
                commit = true;
            }
            if (commit) {
                this.commit(watchConfig);
            }
        }

        public synchronized void deleteAllProjectWatches(Account.Id accountId) throws IOException, ConfigInvalidException {
            WatchConfig watchConfig = this.read(accountId);
            boolean commit = false;
            if (!watchConfig.getProjectWatches().isEmpty()) {
                watchConfig.getProjectWatches().clear();
                commit = true;
            }
            if (commit) {
                this.commit(watchConfig);
            }
        }

        private WatchConfig read(Account.Id accountId) throws IOException, ConfigInvalidException {
            try (Repository git = this.repoManager.openRepository(this.allUsersName);){
                WatchConfig watchConfig = new WatchConfig(accountId);
                watchConfig.load(git);
                WatchConfig watchConfig2 = watchConfig;
                return watchConfig2;
            }
        }

        private void commit(WatchConfig watchConfig) throws IOException {
            try (MetaDataUpdate md = this.metaDataUpdateFactory.get().create(this.allUsersName, this.userFactory.create(watchConfig.accountId));){
                watchConfig.commit(md);
            }
        }
    }
}

