/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.config;

import com.google.gerrit.common.Version;
import com.google.gerrit.extensions.api.config.ConsistencyCheckInfo;
import com.google.gerrit.extensions.api.config.ConsistencyCheckInput;
import com.google.gerrit.extensions.api.config.Server;
import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.extensions.client.GeneralPreferencesInfo;
import com.google.gerrit.extensions.common.ServerInfo;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.api.ApiUtil;
import com.google.gerrit.server.config.CheckConsistency;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.config.GetDiffPreferences;
import com.google.gerrit.server.config.GetPreferences;
import com.google.gerrit.server.config.GetServerInfo;
import com.google.gerrit.server.config.SetDiffPreferences;
import com.google.gerrit.server.config.SetPreferences;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class ServerImpl
implements Server {
    private final GetPreferences getPreferences;
    private final SetPreferences setPreferences;
    private final GetDiffPreferences getDiffPreferences;
    private final SetDiffPreferences setDiffPreferences;
    private final GetServerInfo getServerInfo;
    private final Provider<CheckConsistency> checkConsistency;

    @Inject
    ServerImpl(GetPreferences getPreferences, SetPreferences setPreferences, GetDiffPreferences getDiffPreferences, SetDiffPreferences setDiffPreferences, GetServerInfo getServerInfo, Provider<CheckConsistency> checkConsistency) {
        this.getPreferences = getPreferences;
        this.setPreferences = setPreferences;
        this.getDiffPreferences = getDiffPreferences;
        this.setDiffPreferences = setDiffPreferences;
        this.getServerInfo = getServerInfo;
        this.checkConsistency = checkConsistency;
    }

    @Override
    public String getVersion() throws RestApiException {
        return Version.getVersion();
    }

    @Override
    public ServerInfo getInfo() throws RestApiException {
        try {
            return this.getServerInfo.apply(new ConfigResource());
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot get server info", e);
        }
    }

    @Override
    public GeneralPreferencesInfo getDefaultPreferences() throws RestApiException {
        try {
            return this.getPreferences.apply(new ConfigResource());
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot get default general preferences", e);
        }
    }

    @Override
    public GeneralPreferencesInfo setDefaultPreferences(GeneralPreferencesInfo in) throws RestApiException {
        try {
            return this.setPreferences.apply(new ConfigResource(), in);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot set default general preferences", e);
        }
    }

    @Override
    public DiffPreferencesInfo getDefaultDiffPreferences() throws RestApiException {
        try {
            return this.getDiffPreferences.apply(new ConfigResource());
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot get default diff preferences", e);
        }
    }

    @Override
    public DiffPreferencesInfo setDefaultDiffPreferences(DiffPreferencesInfo in) throws RestApiException {
        try {
            return this.setDiffPreferences.apply(new ConfigResource(), in);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot set default diff preferences", e);
        }
    }

    @Override
    public ConsistencyCheckInfo checkConsistency(ConsistencyCheckInput in) throws RestApiException {
        try {
            return this.checkConsistency.get().apply(new ConfigResource(), in);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot check consistency", e);
        }
    }
}

