/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.groups;

import com.google.common.base.Preconditions;
import com.google.gerrit.extensions.api.groups.GroupApi;
import com.google.gerrit.extensions.api.groups.GroupInput;
import com.google.gerrit.extensions.api.groups.Groups;
import com.google.gerrit.extensions.client.ListGroupsOption;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.api.ApiUtil;
import com.google.gerrit.server.api.groups.GroupApiImpl;
import com.google.gerrit.server.group.CreateGroup;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.group.ListGroups;
import com.google.gerrit.server.group.QueryGroups;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.project.ProjectsCollection;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.List;
import java.util.SortedMap;

@Singleton
class GroupsImpl
implements Groups {
    private final AccountsCollection accounts;
    private final GroupsCollection groups;
    private final ProjectsCollection projects;
    private final Provider<ListGroups> listGroups;
    private final Provider<QueryGroups> queryGroups;
    private final Provider<CurrentUser> user;
    private final PermissionBackend permissionBackend;
    private final CreateGroup.Factory createGroup;
    private final GroupApiImpl.Factory api;

    @Inject
    GroupsImpl(AccountsCollection accounts, GroupsCollection groups, ProjectsCollection projects, Provider<ListGroups> listGroups, Provider<QueryGroups> queryGroups, Provider<CurrentUser> user, PermissionBackend permissionBackend, CreateGroup.Factory createGroup, GroupApiImpl.Factory api) {
        this.accounts = accounts;
        this.groups = groups;
        this.projects = projects;
        this.listGroups = listGroups;
        this.queryGroups = queryGroups;
        this.user = user;
        this.permissionBackend = permissionBackend;
        this.createGroup = createGroup;
        this.api = api;
    }

    @Override
    public GroupApi id(String id) throws RestApiException {
        return this.api.create(this.groups.parse(TopLevelResource.INSTANCE, IdString.fromDecoded(id)));
    }

    @Override
    public GroupApi create(String name) throws RestApiException {
        GroupInput in = new GroupInput();
        in.name = name;
        return this.create(in);
    }

    @Override
    public GroupApi create(GroupInput in) throws RestApiException {
        if (Preconditions.checkNotNull(in, (Object)"GroupInput").name == null) {
            throw new BadRequestException("GroupInput must specify name");
        }
        try {
            CreateGroup impl = this.createGroup.create(in.name);
            this.permissionBackend.user(this.user).checkAny(GlobalPermission.fromAnnotation(impl.getClass()));
            GroupInfo info = impl.apply(TopLevelResource.INSTANCE, in);
            return this.id(info.id);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot create group " + in.name, e);
        }
    }

    @Override
    public Groups.ListRequest list() {
        return new Groups.ListRequest(){

            public SortedMap<String, GroupInfo> getAsMap() throws RestApiException {
                return GroupsImpl.this.list(this);
            }
        };
    }

    private SortedMap<String, GroupInfo> list(Groups.ListRequest req) throws RestApiException {
        TopLevelResource tlr = TopLevelResource.INSTANCE;
        ListGroups list = this.listGroups.get();
        list.setOptions(req.getOptions());
        for (String project : req.getProjects()) {
            try {
                list.addProject(this.projects.parse(tlr, IdString.fromDecoded(project)).getControl());
            }
            catch (Exception e) {
                throw ApiUtil.asRestApiException("Error looking up project " + project, e);
            }
        }
        for (String group : req.getGroups()) {
            list.addGroup(this.groups.parse(group).getGroupUUID());
        }
        list.setVisibleToAll(req.getVisibleToAll());
        if (req.getUser() != null) {
            try {
                list.setUser(this.accounts.parse(req.getUser()).getAccountId());
            }
            catch (Exception e) {
                throw ApiUtil.asRestApiException("Error looking up user " + req.getUser(), e);
            }
        }
        list.setOwned(req.getOwned());
        list.setLimit(req.getLimit());
        list.setStart(req.getStart());
        list.setMatchSubstring(req.getSubstring());
        list.setMatchRegex(req.getRegex());
        list.setSuggest(req.getSuggest());
        try {
            return list.apply(tlr);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot list groups", e);
        }
    }

    @Override
    public Groups.QueryRequest query() {
        return new Groups.QueryRequest(){

            @Override
            public List<GroupInfo> get() throws RestApiException {
                return GroupsImpl.this.query(this);
            }
        };
    }

    @Override
    public Groups.QueryRequest query(String query) {
        return this.query().withQuery(query);
    }

    private List<GroupInfo> query(Groups.QueryRequest r) throws RestApiException {
        try {
            QueryGroups myQueryGroups = this.queryGroups.get();
            myQueryGroups.setQuery(r.getQuery());
            myQueryGroups.setLimit(r.getLimit());
            myQueryGroups.setStart(r.getStart());
            for (ListGroupsOption option : r.getOptions()) {
                myQueryGroups.addOption(option);
            }
            return myQueryGroups.apply(TopLevelResource.INSTANCE);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot query groups", e);
        }
    }
}

