/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.plugins;

import com.google.gerrit.extensions.api.plugins.PluginApi;
import com.google.gerrit.extensions.common.PluginInfo;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.plugins.DisablePlugin;
import com.google.gerrit.server.plugins.EnablePlugin;
import com.google.gerrit.server.plugins.GetStatus;
import com.google.gerrit.server.plugins.PluginResource;
import com.google.gerrit.server.plugins.ReloadPlugin;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

public class PluginApiImpl
implements PluginApi {
    private final GetStatus getStatus;
    private final EnablePlugin enable;
    private final DisablePlugin disable;
    private final ReloadPlugin reload;
    private final PluginResource resource;

    @Inject
    PluginApiImpl(GetStatus getStatus, EnablePlugin enable, DisablePlugin disable, ReloadPlugin reload, @Assisted PluginResource resource) {
        this.getStatus = getStatus;
        this.enable = enable;
        this.disable = disable;
        this.reload = reload;
        this.resource = resource;
    }

    @Override
    public PluginInfo get() throws RestApiException {
        return this.getStatus.apply(this.resource);
    }

    @Override
    public void enable() throws RestApiException {
        this.enable.apply(this.resource, new EnablePlugin.Input());
    }

    @Override
    public void disable() throws RestApiException {
        this.disable.apply(this.resource, new DisablePlugin.Input());
    }

    @Override
    public void reload() throws RestApiException {
        this.reload.apply(this.resource, new ReloadPlugin.Input());
    }

    public static interface Factory {
        public PluginApiImpl create(PluginResource var1);
    }
}

