/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.auth;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.server.auth.AutoValue_AuthUser_UUID;

public class AuthUser {
    private final UUID uuid;
    private final String username;

    public AuthUser(UUID uuid, @Nullable String username) {
        this.uuid = Preconditions.checkNotNull(uuid);
        this.username = username;
    }

    public final UUID getUUID() {
        return this.uuid;
    }

    @Nullable
    public final String getUsername() {
        return this.username;
    }

    public final boolean hasUsername() {
        return this.getUsername() != null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AuthUser) {
            return this.getUUID().equals(((AuthUser)obj).getUUID());
        }
        return false;
    }

    public int hashCode() {
        return this.getUUID().hashCode();
    }

    public String toString() {
        return String.format("AuthUser[uuid=%s, username=%s]", this.getUUID(), this.getUsername());
    }

    @AutoValue
    public static abstract class UUID {
        public static UUID create(String uuid) {
            return new AutoValue_AuthUser_UUID(uuid);
        }

        public abstract String uuid();
    }
}

