/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.cache;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.Weigher;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.annotations.PluginName;
import com.google.gerrit.server.cache.CacheBinding;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.cache.MemoryCacheFactory;
import com.google.gerrit.server.cache.PersistentCacheFactory;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.util.concurrent.TimeUnit;

class CacheProvider<K, V>
implements Provider<Cache<K, V>>,
CacheBinding<K, V> {
    private final CacheModule module;
    final String name;
    private final TypeLiteral<K> keyType;
    private final TypeLiteral<V> valType;
    private boolean persist;
    private long maximumWeight;
    private long diskLimit;
    private Long expireAfterWrite;
    private Provider<CacheLoader<K, V>> loader;
    private Provider<Weigher<K, V>> weigher;
    private String plugin;
    private MemoryCacheFactory memoryCacheFactory;
    private PersistentCacheFactory persistentCacheFactory;
    private boolean frozen;

    CacheProvider(CacheModule module, String name, TypeLiteral<K> keyType, TypeLiteral<V> valType) {
        this.module = module;
        this.name = name;
        this.keyType = keyType;
        this.valType = valType;
    }

    @Inject(optional=true)
    void setPluginName(@PluginName String pluginName) {
        this.plugin = pluginName;
    }

    @Inject
    void setMemoryCacheFactory(MemoryCacheFactory factory) {
        this.memoryCacheFactory = factory;
    }

    @Inject(optional=true)
    void setPersistentCacheFactory(@Nullable PersistentCacheFactory factory) {
        this.persistentCacheFactory = factory;
    }

    CacheBinding<K, V> persist(boolean p) {
        Preconditions.checkState(!this.frozen, "binding frozen, cannot be modified");
        this.persist = p;
        return this;
    }

    @Override
    public CacheBinding<K, V> maximumWeight(long weight) {
        Preconditions.checkState(!this.frozen, "binding frozen, cannot be modified");
        this.maximumWeight = weight;
        return this;
    }

    @Override
    public CacheBinding<K, V> diskLimit(long limit) {
        Preconditions.checkState(!this.frozen, "binding frozen, cannot be modified");
        Preconditions.checkState(this.persist, "diskLimit supported for persistent caches only");
        this.diskLimit = limit;
        return this;
    }

    @Override
    public CacheBinding<K, V> expireAfterWrite(long duration, TimeUnit unit) {
        Preconditions.checkState(!this.frozen, "binding frozen, cannot be modified");
        this.expireAfterWrite = TimeUnit.SECONDS.convert(duration, unit);
        return this;
    }

    @Override
    public CacheBinding<K, V> loader(Class<? extends CacheLoader<K, V>> impl) {
        Preconditions.checkState(!this.frozen, "binding frozen, cannot be modified");
        this.loader = this.module.bindCacheLoader(this, impl);
        return this;
    }

    @Override
    public CacheBinding<K, V> weigher(Class<? extends Weigher<K, V>> impl) {
        Preconditions.checkState(!this.frozen, "binding frozen, cannot be modified");
        this.weigher = this.module.bindWeigher(this, impl);
        return this;
    }

    @Override
    public String name() {
        if (!Strings.isNullOrEmpty(this.plugin)) {
            return this.plugin + "." + this.name;
        }
        return this.name;
    }

    @Override
    public TypeLiteral<K> keyType() {
        return this.keyType;
    }

    @Override
    public TypeLiteral<V> valueType() {
        return this.valType;
    }

    @Override
    public long maximumWeight() {
        return this.maximumWeight;
    }

    @Override
    public long diskLimit() {
        if (this.diskLimit > 0L) {
            return this.diskLimit;
        }
        return 0x8000000L;
    }

    @Override
    @Nullable
    public Long expireAfterWrite(TimeUnit unit) {
        return this.expireAfterWrite != null ? Long.valueOf(unit.convert(this.expireAfterWrite, TimeUnit.SECONDS)) : null;
    }

    @Override
    @Nullable
    public Weigher<K, V> weigher() {
        return this.weigher != null ? this.weigher.get() : null;
    }

    @Override
    @Nullable
    public CacheLoader<K, V> loader() {
        return this.loader != null ? this.loader.get() : null;
    }

    @Override
    public Cache<K, V> get() {
        this.frozen = true;
        if (this.loader != null) {
            CacheLoader<K, V> ldr = this.loader.get();
            if (this.persist && this.persistentCacheFactory != null) {
                return this.persistentCacheFactory.build(this, ldr);
            }
            return this.memoryCacheFactory.build(this, ldr);
        }
        if (this.persist && this.persistentCacheFactory != null) {
            return this.persistentCacheFactory.build(this);
        }
        return this.memoryCacheFactory.build(this);
    }
}

