/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.api.changes.IncludedInInfo;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.IncludedIn;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class ChangeIncludedIn
implements RestReadView<ChangeResource> {
    private Provider<ReviewDb> db;
    private PatchSetUtil psUtil;
    private IncludedIn includedIn;

    @Inject
    ChangeIncludedIn(Provider<ReviewDb> db, PatchSetUtil psUtil, IncludedIn includedIn) {
        this.db = db;
        this.psUtil = psUtil;
        this.includedIn = includedIn;
    }

    public IncludedInInfo apply(ChangeResource rsrc) throws RestApiException, OrmException, IOException {
        PatchSet ps = this.psUtil.current(this.db.get(), rsrc.getNotes());
        return this.includedIn.apply(rsrc.getProject(), ps.getRevision().get());
    }
}

