/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.ProjectState;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;

public class PluginConfig {
    private static final String PLUGIN = "plugin";
    private final String pluginName;
    private Config cfg;
    private final ProjectConfig projectConfig;

    public PluginConfig(String pluginName, Config cfg) {
        this(pluginName, cfg, null);
    }

    public PluginConfig(String pluginName, Config cfg, ProjectConfig projectConfig) {
        this.pluginName = pluginName;
        this.cfg = cfg;
        this.projectConfig = projectConfig;
    }

    PluginConfig withInheritance(ProjectState.Factory projectStateFactory) {
        if (this.projectConfig == null) {
            return this;
        }
        ProjectState state = projectStateFactory.create(this.projectConfig);
        ProjectState parent = Iterables.getFirst(state.parents(), null);
        if (parent != null) {
            PluginConfig parentPluginConfig = parent.getConfig().getPluginConfig(this.pluginName).withInheritance(projectStateFactory);
            Set<String> allNames = this.cfg.getNames(PLUGIN, this.pluginName);
            this.cfg = PluginConfig.copyConfig(this.cfg);
            for (String name : parentPluginConfig.cfg.getNames(PLUGIN, this.pluginName)) {
                if (allNames.contains(name)) continue;
                List<String> values = Arrays.asList(parentPluginConfig.cfg.getStringList(PLUGIN, this.pluginName, name));
                for (String value : values) {
                    GroupReference groupRef = parentPluginConfig.projectConfig.getGroup(GroupReference.extractGroupName(value));
                    if (groupRef == null) continue;
                    this.projectConfig.resolve(groupRef);
                }
                this.cfg.setStringList(PLUGIN, this.pluginName, name, values);
            }
        }
        return this;
    }

    private static Config copyConfig(Config cfg) {
        Config copiedCfg = new Config();
        try {
            copiedCfg.fromText(cfg.toText());
        }
        catch (ConfigInvalidException e) {
            throw new IllegalStateException(e);
        }
        return copiedCfg;
    }

    public String getString(String name) {
        return this.cfg.getString(PLUGIN, this.pluginName, name);
    }

    public String getString(String name, String defaultValue) {
        if (defaultValue == null) {
            return this.cfg.getString(PLUGIN, this.pluginName, name);
        }
        return MoreObjects.firstNonNull(this.cfg.getString(PLUGIN, this.pluginName, name), defaultValue);
    }

    public void setString(String name, String value) {
        if (Strings.isNullOrEmpty(value)) {
            this.cfg.unset(PLUGIN, this.pluginName, name);
        } else {
            this.cfg.setString(PLUGIN, this.pluginName, name, value);
        }
    }

    public String[] getStringList(String name) {
        return this.cfg.getStringList(PLUGIN, this.pluginName, name);
    }

    public void setStringList(String name, List<String> values) {
        if (values == null || values.isEmpty()) {
            this.cfg.unset(PLUGIN, this.pluginName, name);
        } else {
            this.cfg.setStringList(PLUGIN, this.pluginName, name, values);
        }
    }

    public int getInt(String name, int defaultValue) {
        return this.cfg.getInt(PLUGIN, this.pluginName, name, defaultValue);
    }

    public void setInt(String name, int value) {
        this.cfg.setInt(PLUGIN, this.pluginName, name, value);
    }

    public long getLong(String name, long defaultValue) {
        return this.cfg.getLong(PLUGIN, this.pluginName, name, defaultValue);
    }

    public void setLong(String name, long value) {
        this.cfg.setLong(PLUGIN, this.pluginName, name, value);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.cfg.getBoolean(PLUGIN, this.pluginName, name, defaultValue);
    }

    public void setBoolean(String name, boolean value) {
        this.cfg.setBoolean(PLUGIN, this.pluginName, name, value);
    }

    public <T extends Enum<?>> T getEnum(String name, T defaultValue) {
        return this.cfg.getEnum(PLUGIN, this.pluginName, name, defaultValue);
    }

    public <T extends Enum<?>> void setEnum(String name, T value) {
        this.cfg.setEnum(PLUGIN, this.pluginName, name, value);
    }

    public <T extends Enum<?>> T getEnum(T[] all, String name, T defaultValue) {
        return (T)this.cfg.getEnum((Enum[])all, PLUGIN, this.pluginName, name, defaultValue);
    }

    public void unset(String name) {
        this.cfg.unset(PLUGIN, this.pluginName, name);
    }

    public Set<String> getNames() {
        return this.cfg.getNames(PLUGIN, this.pluginName, true);
    }

    public GroupReference getGroupReference(String name) {
        return this.projectConfig.getGroup(GroupReference.extractGroupName(this.getString(name)));
    }

    public void setGroupReference(String name, GroupReference value) {
        GroupReference groupRef = this.projectConfig.resolve(value);
        this.setString(name, groupRef.toConfigValue());
    }
}

