/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.events;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.events.RefEvent;
import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

public class CommitReceivedEvent
extends RefEvent
implements AutoCloseable {
    static final String TYPE = "commit-received";
    public ReceiveCommand command;
    public Project project;
    public String refName;
    public RevWalk revWalk;
    public RevCommit commit;
    public IdentifiedUser user;

    public CommitReceivedEvent() {
        super(TYPE);
    }

    public CommitReceivedEvent(ReceiveCommand command, Project project, String refName, ObjectReader reader, ObjectId commitId, IdentifiedUser user) throws IOException {
        this();
        this.command = command;
        this.project = project;
        this.refName = refName;
        this.revWalk = new RevWalk(reader);
        this.commit = this.revWalk.parseCommit(commitId);
        this.user = user;
        this.revWalk.parseBody(this.commit);
    }

    @Override
    public Project.NameKey getProjectNameKey() {
        return this.project.getNameKey();
    }

    @Override
    public String getRefName() {
        return this.refName;
    }

    @Override
    public void close() {
        this.revWalk.close();
    }
}

