/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.extensions.events;

import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.events.GitReferenceUpdatedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.extensions.events.EventUtil;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.transport.ReceiveCommand;

@Singleton
public class GitReferenceUpdated {
    public static final GitReferenceUpdated DISABLED = new GitReferenceUpdated(){

        @Override
        public void fire(Project.NameKey project, RefUpdate refUpdate, ReceiveCommand.Type type, Account updater) {
        }

        @Override
        public void fire(Project.NameKey project, RefUpdate refUpdate, Account updater) {
        }

        @Override
        public void fire(Project.NameKey project, String ref, ObjectId oldObjectId, ObjectId newObjectId, Account updater) {
        }

        @Override
        public void fire(Project.NameKey project, ReceiveCommand cmd, Account updater) {
        }

        @Override
        public void fire(Project.NameKey project, BatchRefUpdate batchRefUpdate, Account updater) {
        }
    };
    private final DynamicSet<GitReferenceUpdatedListener> listeners;
    private final EventUtil util;

    @Inject
    GitReferenceUpdated(DynamicSet<GitReferenceUpdatedListener> listeners, EventUtil util) {
        this.listeners = listeners;
        this.util = util;
    }

    private GitReferenceUpdated() {
        this.listeners = null;
        this.util = null;
    }

    public void fire(Project.NameKey project, RefUpdate refUpdate, ReceiveCommand.Type type, Account updater) {
        this.fire(project, refUpdate.getName(), refUpdate.getOldObjectId(), refUpdate.getNewObjectId(), type, this.util.accountInfo(updater));
    }

    public void fire(Project.NameKey project, RefUpdate refUpdate, Account updater) {
        this.fire(project, refUpdate.getName(), refUpdate.getOldObjectId(), refUpdate.getNewObjectId(), ReceiveCommand.Type.UPDATE, this.util.accountInfo(updater));
    }

    public void fire(Project.NameKey project, String ref, ObjectId oldObjectId, ObjectId newObjectId, Account updater) {
        this.fire(project, ref, oldObjectId, newObjectId, ReceiveCommand.Type.UPDATE, this.util.accountInfo(updater));
    }

    public void fire(Project.NameKey project, ReceiveCommand cmd, Account updater) {
        this.fire(project, cmd.getRefName(), cmd.getOldId(), cmd.getNewId(), cmd.getType(), this.util.accountInfo(updater));
    }

    public void fire(Project.NameKey project, BatchRefUpdate batchRefUpdate, Account updater) {
        if (!this.listeners.iterator().hasNext()) {
            return;
        }
        for (ReceiveCommand cmd : batchRefUpdate.getCommands()) {
            if (cmd.getResult() != ReceiveCommand.Result.OK) continue;
            this.fire(project, cmd.getRefName(), cmd.getOldId(), cmd.getNewId(), cmd.getType(), this.util.accountInfo(updater));
        }
    }

    private void fire(Project.NameKey project, String ref, ObjectId oldObjectId, ObjectId newObjectId, ReceiveCommand.Type type, AccountInfo updater) {
        if (!this.listeners.iterator().hasNext()) {
            return;
        }
        ObjectId o = oldObjectId != null ? oldObjectId : ObjectId.zeroId();
        ObjectId n = newObjectId != null ? newObjectId : ObjectId.zeroId();
        Event event = new Event(project, ref, o.name(), n.name(), type, updater);
        for (GitReferenceUpdatedListener l : this.listeners) {
            try {
                l.onGitReferenceUpdated(event);
            }
            catch (Exception e) {
                this.util.logEventListenerError(this, l, e);
            }
        }
    }

    private static class Event
    implements GitReferenceUpdatedListener.Event {
        private final String projectName;
        private final String ref;
        private final String oldObjectId;
        private final String newObjectId;
        private final ReceiveCommand.Type type;
        private final AccountInfo updater;

        Event(Project.NameKey project, String ref, String oldObjectId, String newObjectId, ReceiveCommand.Type type, AccountInfo updater) {
            this.projectName = project.get();
            this.ref = ref;
            this.oldObjectId = oldObjectId;
            this.newObjectId = newObjectId;
            this.type = type;
            this.updater = updater;
        }

        @Override
        public String getProjectName() {
            return this.projectName;
        }

        @Override
        public String getRefName() {
            return this.ref;
        }

        @Override
        public String getOldObjectId() {
            return this.oldObjectId;
        }

        @Override
        public String getNewObjectId() {
            return this.newObjectId;
        }

        @Override
        public boolean isCreate() {
            return this.type == ReceiveCommand.Type.CREATE;
        }

        @Override
        public boolean isDelete() {
            return this.type == ReceiveCommand.Type.DELETE;
        }

        @Override
        public boolean isNonFastForward() {
            return this.type == ReceiveCommand.Type.UPDATE_NONFASTFORWARD;
        }

        @Override
        public AccountInfo getUpdater() {
            return this.updater;
        }

        public String toString() {
            return String.format("%s[%s,%s: %s -> %s]", this.getClass().getSimpleName(), this.projectName, this.ref, this.oldObjectId, this.newObjectId);
        }

        @Override
        public NotifyHandling getNotify() {
            return NotifyHandling.ALL;
        }
    }
}

