/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.fixes;

import com.google.common.base.Preconditions;
import com.google.gerrit.common.RawInputUtil;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.FixReplacement;
import com.google.gerrit.server.change.FileContentUtil;
import com.google.gerrit.server.edit.tree.ChangeFileContentModification;
import com.google.gerrit.server.edit.tree.TreeModification;
import com.google.gerrit.server.fixes.LineIdentifier;
import com.google.gerrit.server.fixes.StringModifier;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

@Singleton
public class FixReplacementInterpreter {
    private static final Comparator<FixReplacement> ASC_RANGE_FIX_REPLACEMENT_COMPARATOR = Comparator.comparing(fixReplacement -> fixReplacement.range);
    private final FileContentUtil fileContentUtil;

    @Inject
    public FixReplacementInterpreter(FileContentUtil fileContentUtil) {
        this.fileContentUtil = fileContentUtil;
    }

    public List<TreeModification> toTreeModifications(Repository repository, ProjectState projectState, ObjectId patchSetCommitId, List<FixReplacement> fixReplacements) throws ResourceNotFoundException, IOException, ResourceConflictException {
        Preconditions.checkNotNull(fixReplacements, "Fix replacements must not be null");
        Map<String, List<FixReplacement>> fixReplacementsPerFilePath = fixReplacements.stream().collect(Collectors.groupingBy(fixReplacement -> fixReplacement.path));
        ArrayList<TreeModification> treeModifications = new ArrayList<TreeModification>();
        for (Map.Entry<String, List<FixReplacement>> entry : fixReplacementsPerFilePath.entrySet()) {
            TreeModification treeModification = this.toTreeModification(repository, projectState, patchSetCommitId, entry.getKey(), entry.getValue());
            treeModifications.add(treeModification);
        }
        return treeModifications;
    }

    private TreeModification toTreeModification(Repository repository, ProjectState projectState, ObjectId patchSetCommitId, String filePath, List<FixReplacement> fixReplacements) throws ResourceNotFoundException, IOException, ResourceConflictException {
        String fileContent = this.getFileContent(repository, projectState, patchSetCommitId, filePath);
        String newFileContent = FixReplacementInterpreter.getNewFileContent(fileContent, fixReplacements);
        return new ChangeFileContentModification(filePath, RawInputUtil.create(newFileContent));
    }

    private String getFileContent(Repository repository, ProjectState projectState, ObjectId patchSetCommitId, String filePath) throws ResourceNotFoundException, IOException {
        try (BinaryResult fileContent = this.fileContentUtil.getContent(repository, projectState, patchSetCommitId, filePath);){
            String string = fileContent.asString();
            return string;
        }
    }

    private static String getNewFileContent(String fileContent, List<FixReplacement> fixReplacements) throws ResourceConflictException {
        ArrayList<FixReplacement> sortedReplacements = new ArrayList<FixReplacement>(fixReplacements);
        sortedReplacements.sort(ASC_RANGE_FIX_REPLACEMENT_COMPARATOR);
        LineIdentifier lineIdentifier = new LineIdentifier(fileContent);
        StringModifier fileContentModifier = new StringModifier(fileContent);
        for (FixReplacement fixReplacement : sortedReplacements) {
            Comment.Range range = fixReplacement.range;
            try {
                int startLineIndex = lineIdentifier.getStartIndexOfLine(range.startLine);
                int startLineLength = lineIdentifier.getLengthOfLine(range.startLine);
                int endLineIndex = lineIdentifier.getStartIndexOfLine(range.endLine);
                int endLineLength = lineIdentifier.getLengthOfLine(range.endLine);
                if (range.startChar > startLineLength || range.endChar > endLineLength) {
                    throw new ResourceConflictException(String.format("Range %s refers to a non-existent offset (start line length: %s, end line length: %s)", FixReplacementInterpreter.toString(range), startLineLength, endLineLength));
                }
                int startIndex = startLineIndex + range.startChar;
                int endIndex = endLineIndex + range.endChar;
                fileContentModifier.replace(startIndex, endIndex, fixReplacement.replacement);
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new ResourceConflictException(String.format("Cannot apply fix replacement for range %s", FixReplacementInterpreter.toString(range)), e);
            }
        }
        return fileContentModifier.getResult();
    }

    private static String toString(Comment.Range range) {
        return String.format("(%s:%s - %s:%s)", range.startLine, range.startChar, range.endLine, range.endChar);
    }
}

