/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.strategy.SubmitStrategy;
import com.google.gerrit.server.git.strategy.SubmitStrategyOp;
import com.google.gerrit.server.update.RepoContext;
import java.io.IOException;
import org.eclipse.jgit.lib.PersonIdent;

class MergeOneOp
extends SubmitStrategyOp {
    MergeOneOp(SubmitStrategy.Arguments args, CodeReviewCommit toMerge) {
        super(args, toMerge);
    }

    @Override
    public void updateRepoImpl(RepoContext ctx) throws IntegrationException, IOException {
        PersonIdent caller = ctx.getIdentifiedUser().newCommitterIdent(this.args.serverIdent.getWhen(), this.args.serverIdent.getTimeZone());
        if (this.args.mergeTip.getCurrentTip() == null) {
            throw new IllegalStateException("cannot merge commit " + this.toMerge.name() + " onto a null tip; expected at least one fast-forward prior to this operation");
        }
        CodeReviewCommit merged = this.args.mergeUtil.mergeOneCommit(caller, this.args.serverIdent, this.args.rw, ctx.getInserter(), ctx.getRepoView().getConfig(), this.args.destBranch, this.args.mergeTip.getCurrentTip(), this.toMerge);
        this.args.mergeTip.moveTipTo(this.amendGitlink(merged), this.toMerge);
    }
}

