/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.common.collect.ListMultimap;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.api.changes.SubmitInput;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.MergeOp;
import com.google.gerrit.server.git.MergeTip;
import com.google.gerrit.server.git.SubmoduleOp;
import com.google.gerrit.server.git.strategy.CherryPick;
import com.google.gerrit.server.git.strategy.FastForwardOnly;
import com.google.gerrit.server.git.strategy.MergeAlways;
import com.google.gerrit.server.git.strategy.MergeIfNecessary;
import com.google.gerrit.server.git.strategy.RebaseAlways;
import com.google.gerrit.server.git.strategy.RebaseIfNecessary;
import com.google.gerrit.server.git.strategy.SubmitStrategy;
import com.google.gerrit.server.util.RequestId;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Set;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SubmitStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(SubmitStrategyFactory.class);
    private final SubmitStrategy.Arguments.Factory argsFactory;

    @Inject
    SubmitStrategyFactory(SubmitStrategy.Arguments.Factory argsFactory) {
        this.argsFactory = argsFactory;
    }

    public SubmitStrategy create(SubmitType submitType, ReviewDb db, CodeReviewCommit.CodeReviewRevWalk rw, RevFlag canMergeFlag, Set<RevCommit> alreadyAccepted, Set<CodeReviewCommit> incoming, Branch.NameKey destBranch, IdentifiedUser caller, MergeTip mergeTip, MergeOp.CommitStatus commitStatus, RequestId submissionId, SubmitInput submitInput, ListMultimap<RecipientType, Account.Id> accountsToNotify, SubmoduleOp submoduleOp, boolean dryrun) throws IntegrationException {
        SubmitStrategy.Arguments args = this.argsFactory.create(submitType, destBranch, commitStatus, rw, caller, mergeTip, canMergeFlag, db, alreadyAccepted, incoming, submissionId, submitInput, accountsToNotify, submoduleOp, dryrun);
        switch (submitType) {
            case CHERRY_PICK: {
                return new CherryPick(args);
            }
            case FAST_FORWARD_ONLY: {
                return new FastForwardOnly(args);
            }
            case MERGE_ALWAYS: {
                return new MergeAlways(args);
            }
            case MERGE_IF_NECESSARY: {
                return new MergeIfNecessary(args);
            }
            case REBASE_IF_NECESSARY: {
                return new RebaseIfNecessary(args);
            }
            case REBASE_ALWAYS: {
                return new RebaseAlways(args);
            }
        }
        String errorMsg = "No submit strategy for: " + (Object)((Object)submitType);
        log.error(errorMsg);
        throw new IntegrationException(errorMsg);
    }
}

