/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.gerrit.common.data.ParameterizedString;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.config.AnonymousCowardName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.mail.MailUtil;
import com.google.gerrit.server.mail.send.FromAddressGenerator;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.PersonIdent;

@Singleton
public class FromAddressGeneratorProvider
implements Provider<FromAddressGenerator> {
    private final FromAddressGenerator generator;

    @Inject
    FromAddressGeneratorProvider(@GerritServerConfig Config cfg, @AnonymousCowardName String anonymousCowardName, @GerritPersonIdent PersonIdent myIdent, AccountCache accountCache) {
        String from = cfg.getString("sendemail", null, "from");
        Address srvAddr = FromAddressGeneratorProvider.toAddress(myIdent);
        if (from == null || "MIXED".equalsIgnoreCase(from)) {
            ParameterizedString name = new ParameterizedString("${user} (Code Review)");
            this.generator = new PatternGen(srvAddr, accountCache, anonymousCowardName, name, srvAddr.getEmail());
        } else if ("USER".equalsIgnoreCase(from)) {
            String[] domains = cfg.getStringList("sendemail", null, "allowedDomain");
            Pattern domainPattern = MailUtil.glob(domains);
            ParameterizedString namePattern = new ParameterizedString("${user} (Code Review)");
            this.generator = new UserGen(accountCache, domainPattern, anonymousCowardName, namePattern, srvAddr);
        } else if ("SERVER".equalsIgnoreCase(from)) {
            this.generator = new ServerGen(srvAddr);
        } else {
            Address a = Address.parse(from);
            ParameterizedString name = a.getName() != null ? new ParameterizedString(a.getName()) : null;
            this.generator = name == null || name.getParameterNames().isEmpty() ? new ServerGen(a) : new PatternGen(srvAddr, accountCache, anonymousCowardName, name, a.getEmail());
        }
    }

    private static Address toAddress(PersonIdent myIdent) {
        return new Address(myIdent.getName(), myIdent.getEmailAddress());
    }

    @Override
    public FromAddressGenerator get() {
        return this.generator;
    }

    private static String hashOf(String data) {
        try {
            MessageDigest hash = MessageDigest.getInstance("MD5");
            byte[] bytes = hash.digest(data.getBytes(StandardCharsets.UTF_8));
            return Base64.encodeBase64URLSafeString(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No MD5 available", e);
        }
    }

    static final class PatternGen
    implements FromAddressGenerator {
        private final ParameterizedString senderEmailPattern;
        private final Address serverAddress;
        private final AccountCache accountCache;
        private final String anonymousCowardName;
        private final ParameterizedString namePattern;

        PatternGen(Address serverAddress, AccountCache accountCache, String anonymousCowardName, ParameterizedString namePattern, String senderEmail) {
            this.senderEmailPattern = new ParameterizedString(senderEmail);
            this.serverAddress = serverAddress;
            this.accountCache = accountCache;
            this.anonymousCowardName = anonymousCowardName;
            this.namePattern = namePattern;
        }

        @Override
        public boolean isGenericAddress(Account.Id fromId) {
            return false;
        }

        @Override
        public Address from(Account.Id fromId) {
            String senderName;
            if (fromId != null) {
                Account account = this.accountCache.get(fromId).getAccount();
                String fullName = account.getFullName();
                if (fullName == null || "".equals(fullName)) {
                    fullName = this.anonymousCowardName;
                }
                senderName = this.namePattern.replace("user", fullName).toString();
            } else {
                senderName = this.serverAddress.getName();
            }
            String senderEmail = this.senderEmailPattern.getParameterNames().isEmpty() ? this.senderEmailPattern.getRawPattern() : this.senderEmailPattern.replace("userHash", FromAddressGeneratorProvider.hashOf(senderName)).toString();
            return new Address(senderName, senderEmail);
        }
    }

    static final class ServerGen
    implements FromAddressGenerator {
        private final Address srvAddr;

        ServerGen(Address srvAddr) {
            this.srvAddr = srvAddr;
        }

        @Override
        public boolean isGenericAddress(Account.Id fromId) {
            return true;
        }

        @Override
        public Address from(Account.Id fromId) {
            return this.srvAddr;
        }
    }

    static final class UserGen
    implements FromAddressGenerator {
        private final AccountCache accountCache;
        private final Pattern domainPattern;
        private final String anonymousCowardName;
        private final ParameterizedString nameRewriteTmpl;
        private final Address serverAddress;

        UserGen(AccountCache accountCache, Pattern domainPattern, String anonymousCowardName, ParameterizedString nameRewriteTmpl, Address serverAddress) {
            this.accountCache = accountCache;
            this.domainPattern = domainPattern;
            this.anonymousCowardName = anonymousCowardName;
            this.nameRewriteTmpl = nameRewriteTmpl;
            this.serverAddress = serverAddress;
        }

        @Override
        public boolean isGenericAddress(Account.Id fromId) {
            return false;
        }

        @Override
        public Address from(Account.Id fromId) {
            String senderName;
            if (fromId != null) {
                Account a = this.accountCache.get(fromId).getAccount();
                String fullName = a.getFullName();
                String userEmail = a.getPreferredEmail();
                if (this.canRelay(userEmail)) {
                    return new Address(fullName, userEmail);
                }
                if (fullName == null || "".equals(fullName.trim())) {
                    fullName = this.anonymousCowardName;
                }
                senderName = this.nameRewriteTmpl.replace("user", fullName).toString();
            } else {
                senderName = this.serverAddress.getName();
            }
            ParameterizedString senderEmailPattern = new ParameterizedString(this.serverAddress.getEmail());
            String senderEmail = senderEmailPattern.getParameterNames().isEmpty() ? senderEmailPattern.getRawPattern() : senderEmailPattern.replace("userHash", FromAddressGeneratorProvider.hashOf(senderName)).toString();
            return new Address(senderName, senderEmail);
        }

        private boolean canRelay(String userEmail) {
            int index;
            if (userEmail != null && (index = userEmail.indexOf(64)) > 0 && index < userEmail.length() - 1) {
                return this.domainPattern.matcher(userEmail.substring(index + 1)).matches();
            }
            return false;
        }
    }
}

