/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.annotations.VisibleForTesting;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.notedb.ChangeBundle;
import com.google.gerrit.server.notedb.NoteDbUpdateManager;
import com.google.gerrit.server.notedb.rebuild.ChangeRebuilder;
import com.google.gerrit.server.notedb.rebuild.ChangeRebuilderImpl;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

@Singleton
@VisibleForTesting
public class TestChangeRebuilderWrapper
extends ChangeRebuilder {
    private final ChangeRebuilderImpl delegate;
    private final AtomicBoolean failNextUpdate;
    private final AtomicBoolean stealNextUpdate;

    @Inject
    TestChangeRebuilderWrapper(SchemaFactory<ReviewDb> schemaFactory, ChangeRebuilderImpl rebuilder) {
        super(schemaFactory);
        this.delegate = rebuilder;
        this.failNextUpdate = new AtomicBoolean();
        this.stealNextUpdate = new AtomicBoolean();
    }

    public void failNextUpdate() {
        this.failNextUpdate.set(true);
    }

    public void stealNextUpdate() {
        this.stealNextUpdate.set(true);
    }

    @Override
    public NoteDbUpdateManager.Result rebuild(ReviewDb db, Change.Id changeId) throws IOException, OrmException {
        return this.rebuild(db, changeId, true);
    }

    @Override
    public NoteDbUpdateManager.Result rebuildEvenIfReadOnly(ReviewDb db, Change.Id changeId) throws IOException, OrmException {
        return this.rebuild(db, changeId, false);
    }

    private NoteDbUpdateManager.Result rebuild(ReviewDb db, Change.Id changeId, boolean checkReadOnly) throws IOException, OrmException {
        NoteDbUpdateManager.Result result;
        if (this.failNextUpdate.getAndSet(false)) {
            throw new IOException("Update failed");
        }
        NoteDbUpdateManager.Result result2 = result = checkReadOnly ? this.delegate.rebuild(db, changeId) : this.delegate.rebuildEvenIfReadOnly(db, changeId);
        if (this.stealNextUpdate.getAndSet(false)) {
            throw new IOException("Update stolen");
        }
        return result;
    }

    @Override
    public NoteDbUpdateManager.Result rebuild(NoteDbUpdateManager manager, ChangeBundle bundle) throws IOException, OrmException {
        return this.delegate.rebuild(manager, bundle);
    }

    @Override
    public NoteDbUpdateManager stage(ReviewDb db, Change.Id changeId) throws IOException, OrmException {
        return this.delegate.stage(db, changeId);
    }

    @Override
    public NoteDbUpdateManager.Result execute(ReviewDb db, Change.Id changeId, NoteDbUpdateManager manager) throws OrmException, IOException {
        if (this.failNextUpdate.getAndSet(false)) {
            throw new IOException("Update failed");
        }
        NoteDbUpdateManager.Result result = this.delegate.execute(db, changeId, manager);
        if (this.stealNextUpdate.getAndSet(false)) {
            throw new IOException("Update stolen");
        }
        return result;
    }

    @Override
    public void buildUpdates(NoteDbUpdateManager manager, ChangeBundle bundle) throws IOException, OrmException {
        this.delegate.buildUpdates(manager, bundle);
    }

    @Override
    public void rebuildReviewDb(ReviewDb db, Project.NameKey project, Change.Id changeId) throws OrmException {
        if (this.failNextUpdate.getAndSet(false)) {
            throw new OrmException("Update failed");
        }
        this.delegate.rebuildReviewDb(db, project, changeId);
    }
}

