/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.plugins.PluginLoader;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class PluginCleanerTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PluginCleanerTask.class);
    private final WorkQueue workQueue;
    private final PluginLoader loader;
    private volatile int pending;
    private Future<?> self;
    private int attempts;
    private long start;

    @Inject
    PluginCleanerTask(WorkQueue workQueue, PluginLoader loader) {
        this.workQueue = workQueue;
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            for (int t = 0; t < 2 * (this.attempts + 1); ++t) {
                System.gc();
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException t) {
            // empty catch block
        }
        int left = this.loader.processPendingCleanups();
        PluginCleanerTask pluginCleanerTask = this;
        synchronized (pluginCleanerTask) {
            this.pending = left;
            this.self = null;
            if (0 < left) {
                long waiting = TimeUtil.nowMs() - this.start;
                log.warn("{} plugins still waiting to be reclaimed after {} minutes", (Object)this.pending, (Object)TimeUnit.MILLISECONDS.toMinutes(waiting));
                this.attempts = Math.min(this.attempts + 1, 15);
                this.ensureScheduled();
            } else {
                this.attempts = 0;
            }
        }
    }

    public String toString() {
        int p = this.pending;
        if (0 < p) {
            return String.format("Plugin Cleaner (waiting for %d plugins)", p);
        }
        return "Plugin Cleaner";
    }

    synchronized void clean(int expect) {
        if (this.self == null && this.pending == 0) {
            this.start = TimeUtil.nowMs();
        }
        this.pending = expect;
        this.ensureScheduled();
    }

    private void ensureScheduled() {
        if (this.self == null && 0 < this.pending) {
            this.self = this.attempts == 1 ? this.workQueue.getDefaultQueue().schedule(this, 30L, TimeUnit.SECONDS) : this.workQueue.getDefaultQueue().schedule(this, (long)(this.attempts + 1), TimeUnit.MINUTES);
        }
    }
}

