/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.change.IncludedInResolver;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.VisibleRefFilter;
import com.google.gerrit.server.index.change.ChangeIndexCollection;
import com.google.gerrit.server.project.CommitResource;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CommitsCollection
implements ChildCollection<ProjectResource, CommitResource> {
    private static final Logger log = LoggerFactory.getLogger(CommitsCollection.class);
    private final DynamicMap<RestView<CommitResource>> views;
    private final GitRepositoryManager repoManager;
    private final VisibleRefFilter.Factory refFilter;
    private final ChangeIndexCollection indexes;
    private final Provider<InternalChangeQuery> queryProvider;

    @Inject
    public CommitsCollection(DynamicMap<RestView<CommitResource>> views, GitRepositoryManager repoManager, VisibleRefFilter.Factory refFilter, ChangeIndexCollection indexes, Provider<InternalChangeQuery> queryProvider) {
        this.views = views;
        this.repoManager = repoManager;
        this.refFilter = refFilter;
        this.indexes = indexes;
        this.queryProvider = queryProvider;
    }

    @Override
    public RestView<ProjectResource> list() throws ResourceNotFoundException {
        throw new ResourceNotFoundException();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public CommitResource parse(ProjectResource parent, IdString id) throws ResourceNotFoundException, IOException {
        ObjectId objectId;
        try {
            objectId = ObjectId.fromString(id.get());
        }
        catch (IllegalArgumentException e) {
            throw new ResourceNotFoundException(id);
        }
        try {
            Throwable throwable = null;
            try (Repository repo = this.repoManager.openRepository(parent.getNameKey());){
                CommitResource commitResource;
                RevWalk rw = new RevWalk(repo);
                Throwable throwable2 = null;
                try {
                    RevCommit commit = rw.parseCommit(objectId);
                    rw.parseBody(commit);
                    if (!this.canRead(parent.getProjectState(), repo, commit)) {
                        throw new ResourceNotFoundException(id);
                    }
                    for (int i = 0; i < commit.getParentCount(); ++i) {
                        rw.parseBody(rw.parseCommit(commit.getParent(i)));
                    }
                    commitResource = new CommitResource(parent, commit);
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            CommitsCollection.$closeResource(throwable2, rw);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                CommitsCollection.$closeResource(throwable2, rw);
                return commitResource;
            }
        }
        catch (IncorrectObjectTypeException | MissingObjectException e) {
            throw new ResourceNotFoundException(id);
        }
    }

    @Override
    public DynamicMap<RestView<CommitResource>> views() {
        return this.views;
    }

    public boolean canRead(ProjectState state, Repository repo, RevCommit commit) {
        Project.NameKey project = state.getNameKey();
        if (this.indexes.getSearchIndex() != null) {
            try {
                List<ChangeData> changes = this.queryProvider.get().enforceVisibility(true).byProjectCommit(project, commit);
                if (!changes.isEmpty()) {
                    return true;
                }
            }
            catch (OrmException e) {
                log.error("Cannot look up change for commit {} in {}", commit.name(), project, e);
            }
        }
        return this.isReachableFrom(state, repo, commit, repo.getAllRefs());
    }

    public boolean isReachableFrom(ProjectState state, Repository repo, RevCommit commit, Map<String, Ref> refs) {
        boolean bl;
        RevWalk rw = new RevWalk(repo);
        Throwable throwable = null;
        try {
            refs = this.refFilter.create(state, repo).filter(refs, true);
            bl = IncludedInResolver.includedInAny(repo, rw, commit, refs.values());
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CommitsCollection.$closeResource(throwable, rw);
                    throw throwable3;
                }
            }
            catch (IOException e) {
                log.error("Cannot verify permissions to commit object {} in repository {}", commit.name(), state.getNameKey(), e);
                return false;
            }
        }
        CommitsCollection.$closeResource(throwable, rw);
        return bl;
    }
}

