/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;

@Singleton
public class SetParent
implements RestModifyView<ProjectResource, Input> {
    private final ProjectCache cache;
    private final PermissionBackend permissionBackend;
    private final MetaDataUpdate.Server updateFactory;
    private final AllProjectsName allProjects;

    @Inject
    SetParent(ProjectCache cache, PermissionBackend permissionBackend, MetaDataUpdate.Server updateFactory, AllProjectsName allProjects) {
        this.cache = cache;
        this.permissionBackend = permissionBackend;
        this.updateFactory = updateFactory;
        this.allProjects = allProjects;
    }

    public String apply(ProjectResource rsrc, Input input) throws AuthException, ResourceConflictException, ResourceNotFoundException, UnprocessableEntityException, IOException, PermissionBackendException {
        return this.apply(rsrc, input, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String apply(ProjectResource rsrc, Input input, boolean checkIfAdmin) throws AuthException, ResourceConflictException, ResourceNotFoundException, UnprocessableEntityException, IOException, PermissionBackendException {
        IdentifiedUser user = rsrc.getUser().asIdentifiedUser();
        String parentName = MoreObjects.firstNonNull(Strings.emptyToNull(input.parent), this.allProjects.get());
        this.validateParentUpdate(rsrc.getProjectState().getNameKey(), user, parentName, checkIfAdmin);
        try (MetaDataUpdate md = this.updateFactory.create(rsrc.getNameKey());){
            ProjectConfig config = ProjectConfig.read(md);
            Project project = config.getProject();
            project.setParentName(parentName);
            String msg = Strings.emptyToNull(input.commitMessage);
            if (msg == null) {
                msg = String.format("Changed parent to %s.\n", parentName);
            } else if (!msg.endsWith("\n")) {
                msg = msg + "\n";
            }
            md.setAuthor(user);
            md.setMessage(msg);
            config.commit(md);
            this.cache.evict(rsrc.getProjectState().getProject());
            Project.NameKey parent = project.getParent(this.allProjects);
            Preconditions.checkNotNull(parent);
            String string = parent.get();
            return string;
        }
        catch (RepositoryNotFoundException notFound) {
            throw new ResourceNotFoundException(rsrc.getName());
        }
        catch (ConfigInvalidException e) {
            throw new ResourceConflictException(String.format("invalid project.config: %s", e.getMessage()));
        }
    }

    public void validateParentUpdate(Project.NameKey project, IdentifiedUser user, String newParent, boolean checkIfAdmin) throws AuthException, ResourceConflictException, UnprocessableEntityException, PermissionBackendException {
        if (checkIfAdmin) {
            this.permissionBackend.user(user).check(GlobalPermission.ADMINISTRATE_SERVER);
        }
        if (project.equals(this.allProjects)) {
            throw new ResourceConflictException("cannot set parent of " + this.allProjects.get());
        }
        if ((newParent = Strings.emptyToNull(newParent)) != null) {
            ProjectState parent = this.cache.get(new Project.NameKey(newParent));
            if (parent == null) {
                throw new UnprocessableEntityException("parent project " + newParent + " not found");
            }
            if (Iterables.tryFind(parent.tree(), p -> p.getNameKey().equals(project)).isPresent()) {
                throw new ResourceConflictException("cycle exists between " + project.get() + " and " + parent.getName());
            }
        }
    }

    public static class Input {
        @DefaultInput
        public String parent;
        public String commitMessage;
    }
}

