/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.index.query.IsVisibleToPredicate;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.index.IndexUtils;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Provider;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeIsVisibleToPredicate
extends IsVisibleToPredicate<ChangeData> {
    private static final Logger log = LoggerFactory.getLogger(ChangeIsVisibleToPredicate.class);
    protected final Provider<ReviewDb> db;
    protected final ChangeNotes.Factory notesFactory;
    protected final CurrentUser user;
    protected final PermissionBackend permissionBackend;

    public ChangeIsVisibleToPredicate(Provider<ReviewDb> db, ChangeNotes.Factory notesFactory, CurrentUser user, PermissionBackend permissionBackend) {
        super("visibleto", IndexUtils.describe(user));
        this.db = db;
        this.notesFactory = notesFactory;
        this.user = user;
        this.permissionBackend = permissionBackend;
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        boolean visible;
        if (cd.fastIsVisibleTo(this.user)) {
            return true;
        }
        Change change = cd.change();
        if (change == null) {
            return false;
        }
        ChangeNotes notes = this.notesFactory.createFromIndexedChange(change);
        try {
            visible = ((PermissionBackend.ForChange)this.permissionBackend.user(this.user).indexedChange(cd, notes).database(this.db)).test(ChangePermission.READ);
        }
        catch (PermissionBackendException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RepositoryNotFoundException) {
                log.warn("Skipping change {} because the corresponding repository was not found", (Object)cd.getId(), (Object)e);
                return false;
            }
            throw new OrmException("unable to check permissions on change " + cd.getId(), e);
        }
        if (visible) {
            cd.cacheVisibleTo(this.user);
            return true;
        }
        return false;
    }

    @Override
    public int getCost() {
        return 1;
    }
}

