/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.base.Preconditions;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gwtorm.server.OrmException;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReviewerPredicate
extends ChangeIndexPredicate {
    protected final ReviewerStateInternal state;
    protected final Account.Id id;

    protected static Predicate<ChangeData> forState(Account.Id id, ReviewerStateInternal state) {
        Preconditions.checkArgument(state != ReviewerStateInternal.REMOVED, "can't query by removed reviewer");
        return new ReviewerPredicate(state, id);
    }

    protected static Predicate<ChangeData> reviewer(ChangeQueryBuilder.Arguments args, Account.Id id) {
        if (args.notesMigration.readChanges()) {
            return new ReviewerPredicate(ReviewerStateInternal.REVIEWER, id);
        }
        return ReviewerPredicate.anyReviewerState(id);
    }

    protected static Predicate<ChangeData> cc(Account.Id id) {
        return new ReviewerPredicate(ReviewerStateInternal.CC, id);
    }

    protected static Predicate<ChangeData> anyReviewerState(Account.Id id) {
        return Predicate.or(Stream.of(ReviewerStateInternal.values()).filter(s -> s != ReviewerStateInternal.REMOVED).map(s -> new ReviewerPredicate((ReviewerStateInternal)((Object)s), id)).collect(Collectors.toList()));
    }

    private ReviewerPredicate(ReviewerStateInternal state, Account.Id id) {
        super(ChangeField.REVIEWER, ChangeField.getReviewerFieldValue(state, id));
        this.state = state;
        this.id = id;
    }

    protected Account.Id getAccountId() {
        return this.id;
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        return cd.reviewers().asTable().get((Object)this.state, this.id) != null;
    }

    @Override
    public int getCost() {
        return 1;
    }
}

