/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.group;

import com.google.gerrit.index.FieldDef;
import com.google.gerrit.index.query.IndexPredicate;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gerrit.server.index.group.GroupField;
import java.util.Locale;

public class GroupPredicates {
    public static Predicate<InternalGroup> id(AccountGroup.Id groupId) {
        return new GroupPredicate(GroupField.ID, groupId.toString());
    }

    public static Predicate<InternalGroup> uuid(AccountGroup.UUID uuid) {
        return new GroupPredicate(GroupField.UUID, "uuid", uuid.get());
    }

    public static Predicate<InternalGroup> description(String description) {
        return new GroupPredicate(GroupField.DESCRIPTION, "description", description);
    }

    public static Predicate<InternalGroup> inname(String name) {
        return new GroupPredicate(GroupField.NAME_PART, "inname", name.toLowerCase(Locale.US));
    }

    public static Predicate<InternalGroup> name(String name) {
        return new GroupPredicate(GroupField.NAME, "name", name);
    }

    public static Predicate<InternalGroup> owner(AccountGroup.UUID ownerUuid) {
        return new GroupPredicate(GroupField.OWNER_UUID, "owner", ownerUuid.get());
    }

    public static Predicate<InternalGroup> isVisibleToAll() {
        return new GroupPredicate(GroupField.IS_VISIBLE_TO_ALL, "1");
    }

    public static Predicate<InternalGroup> member(Account.Id memberId) {
        return new GroupPredicate(GroupField.MEMBER, memberId.toString());
    }

    public static Predicate<InternalGroup> subgroup(AccountGroup.UUID subgroupUuid) {
        return new GroupPredicate(GroupField.SUBGROUP, subgroupUuid.get());
    }

    private GroupPredicates() {
    }

    static class GroupPredicate
    extends IndexPredicate<InternalGroup> {
        GroupPredicate(FieldDef<InternalGroup, ?> def, String value) {
            super(def, value);
        }

        GroupPredicate(FieldDef<InternalGroup, ?> def, String name, String value) {
            super(def, name, value);
        }
    }
}

