/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.CurrentSchemaVersion;
import com.google.gerrit.reviewdb.client.SystemConfig;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.GroupUUID;
import com.google.gerrit.server.config.SitePath;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.group.GroupsUpdate;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gerrit.server.index.group.GroupIndex;
import com.google.gerrit.server.index.group.GroupIndexCollection;
import com.google.gerrit.server.schema.AllProjectsCreator;
import com.google.gerrit.server.schema.AllUsersCreator;
import com.google.gerrit.server.schema.DataSourceType;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gwtorm.jdbc.JdbcExecutor;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.PersonIdent;

public class SchemaCreator {
    @SitePath
    private final Path site_path;
    private final AllProjectsCreator allProjectsCreator;
    private final AllUsersCreator allUsersCreator;
    private final PersonIdent serverUser;
    private final DataSourceType dataSourceType;
    private final GroupIndexCollection indexCollection;
    private AccountGroup admin;
    private AccountGroup batch;

    @Inject
    public SchemaCreator(SitePaths site, AllProjectsCreator ap, AllUsersCreator auc, @GerritPersonIdent PersonIdent au, DataSourceType dst, GroupIndexCollection ic) {
        this(site.site_path, ap, auc, au, dst, ic);
    }

    public SchemaCreator(@SitePath Path site, AllProjectsCreator ap, AllUsersCreator auc, @GerritPersonIdent PersonIdent au, DataSourceType dst, GroupIndexCollection ic) {
        this.site_path = site;
        this.allProjectsCreator = ap;
        this.allUsersCreator = auc;
        this.serverUser = au;
        this.dataSourceType = dst;
        this.indexCollection = ic;
    }

    public void create(ReviewDb db) throws OrmException, IOException, ConfigInvalidException {
        JdbcSchema jdbc = (JdbcSchema)((Object)db);
        try (JdbcExecutor e = new JdbcExecutor(jdbc);){
            jdbc.updateSchema(e);
        }
        CurrentSchemaVersion sVer = CurrentSchemaVersion.create();
        sVer.versionNbr = SchemaVersion.getBinaryVersion();
        db.schemaVersion().insert(Collections.singleton(sVer));
        this.createDefaultGroups(db);
        this.initSystemConfig(db);
        this.allProjectsCreator.setAdministrators(GroupReference.forGroup(this.admin)).setBatchUsers(GroupReference.forGroup(this.batch)).create();
        this.allUsersCreator.setAdministrators(GroupReference.forGroup(this.admin)).create();
        this.dataSourceType.getIndexScript().run(db);
    }

    private void createDefaultGroups(ReviewDb db) throws OrmException, IOException {
        this.admin = this.newGroup(db, "Administrators");
        this.admin.setDescription("Gerrit Site Administrators");
        GroupsUpdate.addNewGroup(db, this.admin);
        this.index(InternalGroup.create(this.admin, ImmutableSet.of(), ImmutableSet.of()));
        this.batch = this.newGroup(db, "Non-Interactive Users");
        this.batch.setDescription("Users who perform batch actions on Gerrit");
        this.batch.setOwnerGroupUUID(this.admin.getGroupUUID());
        GroupsUpdate.addNewGroup(db, this.batch);
        this.index(InternalGroup.create(this.batch, ImmutableSet.of(), ImmutableSet.of()));
    }

    private void index(InternalGroup group) throws IOException {
        for (GroupIndex groupIndex : this.indexCollection.getWriteIndexes()) {
            groupIndex.replace(group);
        }
    }

    private AccountGroup newGroup(ReviewDb c, String name) throws OrmException {
        AccountGroup.UUID uuid = GroupUUID.make(name, this.serverUser);
        return new AccountGroup(new AccountGroup.NameKey(name), new AccountGroup.Id(c.nextAccountGroupId()), uuid, TimeUtil.nowTs());
    }

    private SystemConfig initSystemConfig(ReviewDb db) throws OrmException {
        SystemConfig s = SystemConfig.create();
        try {
            s.sitePath = this.site_path.toRealPath(new LinkOption[0]).normalize().toString();
        }
        catch (IOException e) {
            s.sitePath = this.site_path.toAbsolutePath().normalize().toString();
        }
        db.systemConfig().insert(Collections.singleton(s));
        return s;
    }
}

