/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.collect.ImmutableMap;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.AccountConfig;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_153;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema_154
extends SchemaVersion {
    private static final Logger log = LoggerFactory.getLogger(Schema_154.class);
    private static final String TABLE = "accounts";
    private static final Map<String, AccountSetter> ACCOUNT_FIELDS_MAP = ImmutableMap.builder().put("full_name", (a, rs, field) -> a.setFullName(rs.getString(field))).put("preferred_email", (a, rs, field) -> a.setPreferredEmail(rs.getString(field))).put("status", (a, rs, field) -> a.setStatus(rs.getString(field))).put("inactive", (a, rs, field) -> a.setActive(rs.getString(field).equals("N"))).build();
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsersName;
    private final Provider<PersonIdent> serverIdent;

    @Inject
    Schema_154(Provider<Schema_153> prior, GitRepositoryManager repoManager, AllUsersName allUsersName, @GerritPersonIdent Provider<PersonIdent> serverIdent) {
        super(prior);
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
        this.serverIdent = serverIdent;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            TextProgressMonitor pm = new TextProgressMonitor();
            pm.beginTask("Collecting accounts", 0);
            Set<Account> accounts = this.scanAccounts(db, pm);
            pm.endTask();
            pm.beginTask("Migrating accounts to NoteDb", accounts.size());
            for (Account account : accounts) {
                this.updateAccountInNoteDb(repo, account);
                pm.update(1);
            }
            pm.endTask();
        }
        catch (IOException | ConfigInvalidException e) {
            throw new OrmException("Migrating accounts to NoteDb failed", e);
        }
    }

    /*
     * Exception decompiling
     */
    private Set<Account> scanAccounts(ReviewDb db, ProgressMonitor pm) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, AccountSetter> getFields(ReviewDb db) throws SQLException {
        JdbcSchema schema = (JdbcSchema)((Object)db);
        Connection connection = schema.getConnection();
        Set<String> columns = schema.getDialect().listColumns(connection, TABLE);
        return ACCOUNT_FIELDS_MAP.entrySet().stream().filter(e -> columns.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void updateAccountInNoteDb(Repository allUsersRepo, Account account) throws IOException, ConfigInvalidException {
        MetaDataUpdate md = new MetaDataUpdate(GitReferenceUpdated.DISABLED, this.allUsersName, allUsersRepo);
        PersonIdent ident = this.serverIdent.get();
        md.getCommitBuilder().setAuthor(ident);
        md.getCommitBuilder().setCommitter(ident);
        AccountConfig accountConfig = new AccountConfig(null, account.getId());
        accountConfig.load(allUsersRepo);
        accountConfig.setAccount(account);
        accountConfig.commit(md);
    }

    @FunctionalInterface
    private static interface AccountSetter {
        public void set(Account var1, ResultSet var2, String var3) throws SQLException;
    }
}

