/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.annotations.RequiresAnyCapability;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.config.DeleteTask;
import com.google.gerrit.server.config.TaskResource;
import com.google.gerrit.server.config.TasksCollection;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.sshd.AdminHighPriorityCommand;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Argument;

@AdminHighPriorityCommand
@RequiresAnyCapability(value={"killTask", "maintainServer"})
final class KillCommand
extends SshCommand {
    @Inject
    private TasksCollection tasksCollection;
    @Inject
    private DeleteTask deleteTask;
    @Argument(index=0, multiValued=true, required=true, metaVar="ID")
    private final List<String> taskIds = new ArrayList<String>();

    KillCommand() {
    }

    @Override
    protected void run() {
        ConfigResource cfgRsrc = new ConfigResource();
        for (String id : this.taskIds) {
            try {
                TaskResource taskRsrc = this.tasksCollection.parse(cfgRsrc, IdString.fromDecoded(id));
                this.deleteTask.apply(taskRsrc, null);
            }
            catch (AuthException | ResourceNotFoundException | PermissionBackendException e) {
                this.stderr.print("kill: " + id + ": No such task\n");
            }
        }
    }
}

