/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.template.soy.base.AutoValue_SourceLocation_Point;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class SourceLocation
implements Comparable<SourceLocation> {
    @Nonnull
    private final String filePath;
    private final String fileName;
    private final Point begin;
    private final Point end;
    @Deprecated
    public static final SourceLocation UNKNOWN = new SourceLocation("unknown");

    public SourceLocation(String filePath, int beginLine, int beginColumn, int endLine, int endColumn) {
        this(filePath, Point.create(beginLine, beginColumn), Point.create(endLine, endColumn));
    }

    public SourceLocation(String filePath) {
        this(filePath, -1, -1, -1, -1);
    }

    public SourceLocation(String filePath, Point begin, Point end) {
        int lastBangIndex = filePath.lastIndexOf(33);
        if (lastBangIndex != -1) {
            filePath = filePath.substring(lastBangIndex + 1);
        }
        this.fileName = SourceLocation.fileNameFromPath(filePath);
        this.filePath = filePath;
        this.begin = Preconditions.checkNotNull(begin);
        this.end = Preconditions.checkNotNull(end);
    }

    public static String fileNameFromPath(String filePath) {
        int lastSlashIndex = CharMatcher.anyOf("/\\").lastIndexIn(filePath);
        if (lastSlashIndex != -1 && lastSlashIndex != filePath.length() - 1) {
            return filePath.substring(lastSlashIndex + 1);
        }
        return filePath;
    }

    @Nonnull
    public String getFilePath() {
        return this.filePath;
    }

    @Nullable
    public String getFileName() {
        if (UNKNOWN.equals(this)) {
            return null;
        }
        return this.fileName;
    }

    public int getBeginLine() {
        return this.begin.line();
    }

    public int getBeginColumn() {
        return this.begin.column();
    }

    public int getEndLine() {
        return this.end.line();
    }

    public int getEndColumn() {
        return this.end.column();
    }

    @Deprecated
    public boolean isKnown() {
        return !this.equals(UNKNOWN);
    }

    @Override
    public int compareTo(SourceLocation o) {
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.filePath), (Comparable<?>)((Object)o.filePath)).compare(this.begin, o.begin).compare(this.end, o.end).result();
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof SourceLocation)) {
            return false;
        }
        SourceLocation that = (SourceLocation)o;
        return this.filePath.equals(that.filePath) && this.begin.equals(that.begin) && this.end.equals(that.end);
    }

    public int hashCode() {
        return this.filePath.hashCode() + 31 * this.begin.hashCode() + 961 * this.end.hashCode();
    }

    public String toString() {
        return this.begin.line() != -1 ? this.filePath + ":" + this.begin.line() + ":" + this.begin.column() : this.filePath;
    }

    public SourceLocation offsetStartCol(int offset) {
        return new SourceLocation(this.filePath, this.begin.offset(0, offset), this.end);
    }

    public SourceLocation offsetEndCol(int offset) {
        return new SourceLocation(this.filePath, this.begin, this.end.offset(0, offset));
    }

    public SourceLocation extend(SourceLocation other) {
        Preconditions.checkState(this.filePath.equals(other.filePath), "Mismatched files paths: %s and %s", (Object)this.filePath, (Object)other.filePath);
        return new SourceLocation(this.filePath, this.begin, other.end);
    }

    public SourceLocation extend(int lines, int cols) {
        return new SourceLocation(this.filePath, this.begin, this.end.offset(lines, cols));
    }

    public SourceLocation getBeginLocation() {
        return new SourceLocation(this.filePath, this.begin, this.begin);
    }

    public Point getBeginPoint() {
        return this.begin;
    }

    public SourceLocation getEndLocation() {
        return new SourceLocation(this.filePath, this.end, this.end);
    }

    public Point getEndPoint() {
        return this.end;
    }

    public static abstract class Point
    implements Comparable<Point> {
        public static final Point UNKNOWN_POINT = new AutoValue_SourceLocation_Point(-1, -1);

        public static Point create(int line, int column) {
            if (line == -1 && column == -1) {
                return UNKNOWN_POINT;
            }
            Preconditions.checkArgument(line > 0);
            Preconditions.checkArgument(column > 0);
            return new AutoValue_SourceLocation_Point(line, column);
        }

        public abstract int line();

        public abstract int column();

        public Point offset(int byLines, int byColumns) {
            if (this.line() == -1) {
                return this;
            }
            return Point.create(this.line() + byLines, this.column() + byColumns);
        }

        public SourceLocation asLocation(String filePath) {
            return new SourceLocation(filePath, this, this);
        }

        @Override
        public int compareTo(Point o) {
            return ComparisonChain.start().compare(this.line(), o.line()).compare(this.column(), o.column()).result();
        }
    }
}

