/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jssrc.dsl.AutoValue_StatementList;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;

abstract class StatementList
extends CodeChunk {
    StatementList() {
    }

    abstract ImmutableList<? extends CodeChunk> statements();

    static StatementList of(ImmutableList<? extends CodeChunk> statements) {
        Preconditions.checkState(statements.size() > 1, "list of size %s makes no sense", statements.size());
        return new AutoValue_StatementList(statements);
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (CodeChunk codeChunk : this.statements()) {
            codeChunk.collectRequires(collector);
        }
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        for (CodeChunk codeChunk : this.statements()) {
            ctx.appendAll(codeChunk);
        }
    }
}

