/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.Map;

final class SetFullCalleeNamesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind CALL_COLLIDES_WITH_NAMESPACE_ALIAS = SoyErrorKind.of("Call collides with namespace alias ''{0}''");
    private String currNamespace;
    private Map<String, String> currAliasToNamespaceMap;
    private final ErrorReporter errorReporter;

    SetFullCalleeNamesVisitor(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public Void exec(SoyNode soyNode) {
        Preconditions.checkArgument(soyNode instanceof SoyFileSetNode || soyNode instanceof SoyFileNode);
        return (Void)super.exec(soyNode);
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        this.currNamespace = node.getNamespace();
        this.currAliasToNamespaceMap = node.getAliasToNamespaceMap();
        this.visitChildren(node);
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        String srcCalleeName = node.getSrcCalleeName();
        if (srcCalleeName.startsWith(".")) {
            node.setCalleeName(this.currNamespace + srcCalleeName);
        } else if (srcCalleeName.contains(".")) {
            String[] parts = srcCalleeName.split("[.]", 2);
            if (this.currAliasToNamespaceMap.containsKey(parts[0])) {
                String aliasNamespace = this.currAliasToNamespaceMap.get(parts[0]);
                node.setCalleeName(aliasNamespace + '.' + parts[1]);
            } else {
                node.setCalleeName(srcCalleeName);
            }
        } else {
            if (this.currAliasToNamespaceMap.containsKey(srcCalleeName)) {
                this.errorReporter.report(node.getSourceLocation(), CALL_COLLIDES_WITH_NAMESPACE_ALIAS, srcCalleeName);
            }
            node.setCalleeName(srcCalleeName);
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

