/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.restricted;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.internal.targetexpr.TargetExpr;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyListExpr;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class PyExprUtils {
    public static final String TRANSLATOR_NAME = "translator_impl";
    private static final PyExpr EMPTY_STRING = new PyStringExpr("''");
    private static final ImmutableMap<Operator, Integer> PYTHON_PRECEDENCES = new ImmutableMap.Builder<Operator, Integer>().put(Operator.NEGATIVE, 8).put(Operator.TIMES, 7).put(Operator.DIVIDE_BY, 7).put(Operator.MOD, 7).put(Operator.PLUS, 6).put(Operator.MINUS, 6).put(Operator.LESS_THAN, 5).put(Operator.GREATER_THAN, 5).put(Operator.LESS_THAN_OR_EQUAL, 5).put(Operator.GREATER_THAN_OR_EQUAL, 5).put(Operator.EQUAL, 5).put(Operator.NOT_EQUAL, 5).put(Operator.NOT, 4).put(Operator.AND, 3).put(Operator.OR, 2).put(Operator.NULL_COALESCING, 1).put(Operator.CONDITIONAL, 1).build();

    private PyExprUtils() {
    }

    public static PyExpr concatPyExprs(List<? extends PyExpr> pyExprs) {
        if (pyExprs.isEmpty()) {
            return EMPTY_STRING;
        }
        if (pyExprs.size() == 1) {
            return pyExprs.get(0).toPyString();
        }
        StringBuilder resultSb = new StringBuilder();
        resultSb.append("[");
        boolean isFirst = true;
        for (PyExpr pyExpr : pyExprs) {
            if (isFirst) {
                isFirst = false;
            } else {
                resultSb.append(',');
            }
            resultSb.append(pyExpr.toPyString().getText());
        }
        resultSb.append("]");
        return new PyListExpr(resultSb.toString(), Integer.MAX_VALUE);
    }

    public static PyExpr genPyNotNullCheck(PyExpr pyExpr) {
        ImmutableList<PyExpr> exprs = ImmutableList.of(pyExpr, new PyExpr("None", Integer.MAX_VALUE));
        String conditionalExpr = PyExprUtils.genExprWithNewToken(Operator.NOT_EQUAL, exprs, "is not");
        return new PyExpr(conditionalExpr, PyExprUtils.pyPrecedenceForOperator(Operator.NOT_EQUAL));
    }

    public static PyExpr genPyNullCheck(PyExpr expr) {
        ImmutableList<PyExpr> exprs = ImmutableList.of(expr, new PyExpr("None", Integer.MAX_VALUE));
        String conditionalExpr = PyExprUtils.genExprWithNewToken(Operator.EQUAL, exprs, "is");
        return new PyExpr(conditionalExpr, PyExprUtils.pyPrecedenceForOperator(Operator.EQUAL));
    }

    public static PyExpr maybeProtect(PyExpr expr, int minSafePrecedence) {
        if (expr.getPrecedence() > minSafePrecedence) {
            return expr;
        }
        return new PyExpr("(" + expr.getText() + ")", Integer.MAX_VALUE);
    }

    public static PyExpr wrapAsSanitizedContent(SanitizedContent.ContentKind contentKind, PyExpr pyExpr) {
        String sanitizer = NodeContentKinds.toPySanitizedContentOrdainer(contentKind);
        String approval = "sanitize.IActuallyUnderstandSoyTypeSafetyAndHaveSecurityApproval('Internally created Sanitization.')";
        return new PyExpr(sanitizer + "(" + pyExpr.getText() + ", approval=" + approval + ")", Integer.MAX_VALUE);
    }

    public static int pyPrecedenceForOperator(Operator op) {
        return PYTHON_PRECEDENCES.get((Object)op);
    }

    public static PyExpr convertIterableToPyListExpr(Iterable<?> iterable) {
        return PyExprUtils.convertIterableToPyExpr(iterable, true);
    }

    public static PyExpr convertIterableToPyTupleExpr(Iterable<?> iterable) {
        return PyExprUtils.convertIterableToPyExpr(iterable, false);
    }

    public static PyExpr convertMapToOrderedDict(Map<PyExpr, PyExpr> dict) {
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry<PyExpr, PyExpr> entry : dict.entrySet()) {
            values.add("(" + entry.getKey().getText() + ", " + entry.getValue().getText() + ")");
        }
        Joiner joiner = Joiner.on(", ");
        return new PyExpr("collections.OrderedDict([" + joiner.join(values) + "])", Integer.MAX_VALUE);
    }

    public static PyExpr convertMapToPyExpr(Map<PyExpr, PyExpr> dict) {
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry<PyExpr, PyExpr> entry : dict.entrySet()) {
            values.add(entry.getKey().getText() + ": " + entry.getValue().getText());
        }
        Joiner joiner = Joiner.on(", ");
        return new PyExpr("{" + joiner.join(values) + "}", Integer.MAX_VALUE);
    }

    private static PyExpr convertIterableToPyExpr(Iterable<?> iterable, boolean asArray) {
        ArrayList<String> values = new ArrayList<String>();
        String leftDelimiter = "[";
        String rightDelimiter = "]";
        if (!asArray) {
            leftDelimiter = "(";
            rightDelimiter = ")";
        }
        for (Object elem : iterable) {
            if (!(elem instanceof Number || elem instanceof String || elem instanceof PyExpr)) {
                throw new UnsupportedOperationException("Only Number, String and PyExpr is allowed");
            }
            if (elem instanceof Number) {
                values.add(String.valueOf(elem));
                continue;
            }
            if (elem instanceof PyExpr) {
                values.add(((PyExpr)elem).getText());
                continue;
            }
            if (!(elem instanceof String)) continue;
            values.add("'" + elem + "'");
        }
        String contents = Joiner.on(", ").join(values);
        if (values.size() == 1 && !asArray) {
            contents = contents + ",";
        }
        return new PyListExpr(leftDelimiter + contents + rightDelimiter, Integer.MAX_VALUE);
    }

    public static String genExprWithNewToken(Operator op, List<? extends TargetExpr> operandExprs, String newToken) {
        int opPrec = op.getPrecedence();
        boolean isLeftAssociative = op.getAssociativity() == Operator.Associativity.LEFT;
        StringBuilder exprSb = new StringBuilder();
        List<Operator.SyntaxElement> syntax = op.getSyntax();
        int n = syntax.size();
        for (int i = 0; i < n; ++i) {
            Operator.SyntaxElement syntaxEl = syntax.get(i);
            if (syntaxEl instanceof Operator.Operand) {
                int operandIndex = ((Operator.Operand)syntaxEl).getIndex();
                TargetExpr operandExpr = operandExprs.get(operandIndex);
                boolean needsProtection = i == (isLeftAssociative ? 0 : n - 1) ? operandExpr.getPrecedence() < opPrec : operandExpr.getPrecedence() <= opPrec;
                String subexpr = needsProtection ? "(" + operandExpr.getText() + ")" : operandExpr.getText();
                exprSb.append(subexpr);
                continue;
            }
            if (syntaxEl instanceof Operator.Token) {
                if (newToken != null) {
                    exprSb.append(newToken);
                    continue;
                }
                exprSb.append(((Operator.Token)syntaxEl).getValue());
                continue;
            }
            if (syntaxEl instanceof Operator.Spacer) {
                exprSb.append(' ');
                continue;
            }
            throw new AssertionError();
        }
        return exprSb.toString();
    }
}

