/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.proto;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import com.google.template.soy.data.SoyCustomValueConverter;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.proto.SafeStringTypes;
import com.google.template.soy.types.proto.SoyProtoType;
import com.google.template.soy.types.proto.SoyProtoTypeProvider;
import com.google.template.soy.types.proto.SoyProtoValueImpl;
import javax.inject.Inject;

public final class SoyProtoValueConverter
implements SoyCustomValueConverter {
    private final SoyTypeRegistry registry;
    private final SoyProtoTypeProvider protoTypeProvider;

    @VisibleForTesting
    public SoyProtoValueConverter() {
        this(new SoyTypeRegistry(), SoyProtoTypeProvider.empty());
    }

    @Inject
    SoyProtoValueConverter(SoyTypeRegistry registry, SoyProtoTypeProvider protoTypeProvider) {
        this.registry = registry;
        this.protoTypeProvider = protoTypeProvider;
    }

    @Override
    public SoyValueProvider convert(SoyValueConverter valueConverter, Object obj) {
        SoyValueProvider safeStringProvider;
        if (obj instanceof Message.Builder) {
            obj = ((Message.Builder)obj).build();
        }
        if ((safeStringProvider = SafeStringTypes.convertToSoyValue(obj)) != null) {
            return safeStringProvider;
        }
        if (obj instanceof Message) {
            Message message = (Message)obj;
            SoyProtoType type = this.protoTypeProvider.getType(message.getDescriptorForType(), this.registry);
            return new SoyProtoValueImpl(valueConverter, type, message);
        }
        return null;
    }
}

