/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.exceptions;

import com.googlecode.prolog_cafe.exceptions.BuiltinException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;

public class EvaluationException
extends BuiltinException {
    private static final long serialVersionUID = 1L;
    public static final SymbolTerm EVALUATION_ERROR = SymbolTerm.intern("evaluation_error", 3);
    public String errorType;

    public EvaluationException(String string) {
        this.errorType = string;
    }

    public EvaluationException(Operation operation, int n, String string) {
        this.goal = operation;
        this.argNo = n;
        this.errorType = string;
    }

    @Override
    public Term getMessageTerm() {
        Term[] termArray = new Term[]{new JavaObjectTerm(this.goal), new IntegerTerm(this.argNo), SymbolTerm.create(this.errorType)};
        return new StructureTerm(EVALUATION_ERROR, termArray);
    }

    @Override
    public String toString() {
        String string = "{EVALUATION ERROR: " + this.goal.toString();
        if (this.argNo > 0) {
            string = string + " - arg " + this.argNo;
        }
        string = string + ", found " + this.errorType;
        string = string + "}";
        return string;
    }
}

