/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.exceptions;

import com.googlecode.prolog_cafe.exceptions.BuiltinException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;

public class IllegalDomainException
extends BuiltinException {
    private static final long serialVersionUID = 1L;
    public static final SymbolTerm DOMAIN_ERROR = SymbolTerm.intern("domain_error", 4);
    public String domain;
    public Term culprit;

    public IllegalDomainException(String string, Term term) {
        this.domain = string;
        this.culprit = term;
    }

    public IllegalDomainException(Operation operation, int n, String string, Term term) {
        this.goal = operation;
        this.argNo = n;
        this.domain = string;
        this.culprit = term;
    }

    @Override
    public Term getMessageTerm() {
        Term[] termArray = new Term[]{new JavaObjectTerm(this.goal), new IntegerTerm(this.argNo), SymbolTerm.create(this.domain), this.culprit};
        return new StructureTerm(DOMAIN_ERROR, termArray);
    }

    @Override
    public String toString() {
        String string = "{DOMAIN ERROR: " + this.goal.toString();
        if (this.argNo > 0) {
            string = string + " - arg " + this.argNo;
        }
        string = string + ": expected " + this.domain;
        string = string + ", found " + this.culprit.toString();
        string = string + "}";
        return string;
    }
}

