/*
 * Decompiled with CFR 0.152.
 */
package gerrit;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.UserIdentity;
import com.googlecode.prolog_cafe.exceptions.PrologException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;

abstract class AbstractCommitUserIdentityPredicate
extends Predicate.P3 {
    private static final SymbolTerm user = SymbolTerm.intern("user", 1);
    private static final SymbolTerm anonymous = SymbolTerm.intern("anonymous");

    AbstractCommitUserIdentityPredicate(Term a1, Term a2, Term a3, Operation n) {
        this.arg1 = a1;
        this.arg2 = a2;
        this.arg3 = a3;
        this.cont = n;
    }

    protected Operation exec(Prolog engine, UserIdentity userId) throws PrologException {
        String email;
        engine.setB0();
        Term a1 = this.arg1.dereference();
        Term a2 = this.arg2.dereference();
        Term a3 = this.arg3.dereference();
        SymbolTerm nameTerm = Prolog.Nil;
        SymbolTerm emailTerm = Prolog.Nil;
        Account.Id id = userId.getAccount();
        Term idTerm = id == null ? anonymous : new IntegerTerm(id.get());
        String name = userId.getName();
        if (name != null && !name.equals("")) {
            nameTerm = SymbolTerm.create(name);
        }
        if ((email = userId.getEmail()) != null && !email.equals("")) {
            emailTerm = SymbolTerm.create(email);
        }
        if (!a1.unify(new StructureTerm(user, idTerm), engine.trail)) {
            return engine.fail();
        }
        if (!a2.unify(nameTerm, engine.trail)) {
            return engine.fail();
        }
        if (!a3.unify(emailTerm, engine.trail)) {
            return engine.fail();
        }
        return this.cont;
    }
}

