/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchers;

import com.google.common.base.Preconditions;
import org.parboiled.MatcherContext;
import org.parboiled.matchers.AbstractMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;
import org.parboiled.support.Chars;

public class CharIgnoreCaseMatcher
extends AbstractMatcher {
    public final char charLow;
    public final char charUp;

    public CharIgnoreCaseMatcher(char character) {
        super('\'' + Chars.escape(Character.toLowerCase(character)) + '/' + Chars.escape(Character.toUpperCase(character)) + '\'');
        this.charLow = Character.toLowerCase(character);
        this.charUp = Character.toUpperCase(character);
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        char c = context.getCurrentChar();
        if (c != this.charLow && c != this.charUp) {
            return false;
        }
        context.advanceIndex(1);
        context.createNode();
        return true;
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        Preconditions.checkNotNull(visitor, "visitor");
        return visitor.visit(this);
    }
}

