/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import com.github.parboiled1.grappa.misc.SinkAdapter;
import com.github.parboiled1.grappa.misc.SystemOutCharSink;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.io.CharSink;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.parboiled.Context;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Sink;
import org.parboiled.common.Tuple2;
import org.parboiled.matchers.Matcher;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.ParsingResult;
import org.parboiled.support.Position;

public class TracingParseRunner<V>
extends ReportingParseRunner<V>
implements MatchHandler {
    private Predicate<Tuple2<Context<?>, Boolean>> filter = Predicates.alwaysTrue();
    private CharSink log = SystemOutCharSink.INSTANCE;
    private MatcherPath lastPath;

    public TracingParseRunner(Rule rule) {
        super(rule);
    }

    public TracingParseRunner<V> withFilter(@Nonnull Predicate<Tuple2<Context<?>, Boolean>> filter) {
        this.filter = Preconditions.checkNotNull(filter, "filter");
        return this;
    }

    @Deprecated
    public Predicate<Tuple2<Context<?>, Boolean>> getFilter() {
        return this.filter;
    }

    @Deprecated
    public TracingParseRunner<V> withLog(@Nonnull Sink<String> log) {
        Preconditions.checkNotNull(log);
        this.log = new SinkAdapter(log);
        return this;
    }

    @Deprecated
    public Sink<String> getLog() {
        Sink sink = (Sink)((Object)this.log);
        return sink;
    }

    @Override
    protected ParsingResult<V> runBasicMatch(InputBuffer inputBuffer) {
        try {
            this.log.write("Starting new parsing run\n");
        }
        catch (IOException e) {
            throw new RuntimeException("cannot write to CharSink", e);
        }
        this.lastPath = null;
        MatcherContext rootContext = this.createRootContext(inputBuffer, this, true);
        boolean matched = rootContext.runMatcher();
        return this.createParsingResult(matched, rootContext);
    }

    @Override
    public <V> boolean match(MatcherContext<V> context) {
        Matcher matcher = context.getMatcher();
        boolean matched = matcher.match(context);
        Tuple2<MatcherContext<V>, Boolean> input = new Tuple2<MatcherContext<V>, Boolean>(context, matched);
        if (this.filter.apply(input)) {
            try {
                this.print(context, matched);
            }
            catch (IOException e) {
                throw new RuntimeException("cannot write to CharSink", e);
            }
        }
        return matched;
    }

    private void print(MatcherContext<?> context, boolean matched) throws IOException {
        MatcherPath prefix;
        int currentIndex = context.getCurrentIndex();
        Position pos = context.getInputBuffer().getPosition(currentIndex);
        MatcherPath path = context.getPath();
        MatcherPath matcherPath = prefix = this.lastPath != null ? path.commonPrefix(this.lastPath) : null;
        if (prefix != null && prefix.length() > 1) {
            this.log.write("..(" + (prefix.length() - 1) + ")../");
        }
        this.log.write(path.toString(prefix != null ? prefix.getParent() : null));
        String line = context.getInputBuffer().extractLine(pos.line);
        this.log.write(", " + (matched ? "matched" : "failed") + ", cursor at " + pos.line + ':' + pos.column + " after \"" + line.substring(0, Math.min(line.length(), pos.column - 1)) + "\"\n");
        this.lastPath = path;
    }
}

