// Copyright 2010 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.gwtorm.nosql.heap;

import java.util.Comparator;

class HeapKeyComparator implements Comparator<byte[]> {
  static final HeapKeyComparator INSTANCE = new HeapKeyComparator();

  private HeapKeyComparator() {
  }

  @Override
  public int compare(byte[] a, byte[] b) {
    for (int i = 0; i < a.length && i < b.length; i++) {
      final int av = a[i] & 0xff;
      final int bv = b[i] & 0xff;
      final int rc = av - bv;
      if (rc != 0) {
        return rc;
      }
    }

    return a.length - b.length;
  }
}
