/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.api.changes;

import com.google.gerrit.extensions.restapi.DefaultInput;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ReviewInput {
    @DefaultInput
    public String message;
    public Map<String, Short> labels;
    public Map<String, List<Comment>> comments;
    public boolean strictLabels = true;
    public DraftHandling drafts = DraftHandling.DELETE;
    public NotifyHandling notify = NotifyHandling.ALL;
    public String onBehalfOf;

    public ReviewInput message(String msg) {
        this.message = msg != null && !msg.isEmpty() ? msg : null;
        return this;
    }

    public ReviewInput label(String name, short value) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (this.labels == null) {
            this.labels = new LinkedHashMap<String, Short>(4);
        }
        this.labels.put(name, value);
        return this;
    }

    public ReviewInput label(String name, int value) {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.label(name, (short)value);
    }

    public ReviewInput label(String name) {
        return this.label(name, (short)1);
    }

    public static ReviewInput recommend() {
        return new ReviewInput().label("Code-Review", 1);
    }

    public static ReviewInput dislike() {
        return new ReviewInput().label("Code-Review", -1);
    }

    public static ReviewInput approve() {
        return new ReviewInput().label("Code-Review", 2);
    }

    public static ReviewInput reject() {
        return new ReviewInput().label("Code-Review", -2);
    }

    public static class Comment {
        public String id;
        public Side side;
        public int line;
        public String inReplyTo;
        public String message;
        public Range range;

        public static class Range {
            public int startLine;
            public int startCharacter;
            public int endLine;
            public int endCharacter;
        }
    }

    public static enum Side {
        PARENT,
        REVISION;

    }

    public static enum NotifyHandling {
        NONE,
        OWNER,
        OWNER_REVIEWERS,
        ALL;

    }

    public static enum DraftHandling {
        DELETE,
        PUBLISH,
        KEEP;

    }
}

