/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.plugins;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.httpd.plugins.Resource;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

final class SmallResource
extends Resource {
    private final byte[] data;
    private String contentType;
    private String characterEncoding;
    private long lastModified;

    SmallResource(byte[] data) {
        this.data = data;
    }

    SmallResource setLastModified(long when) {
        this.lastModified = when;
        return this;
    }

    SmallResource setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    SmallResource setCharacterEncoding(@Nullable String enc) {
        this.characterEncoding = enc;
        return this;
    }

    @Override
    int weigh() {
        return this.contentType.length() * 2 + this.data.length;
    }

    @Override
    void send(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (0L < this.lastModified) {
            res.setDateHeader("Last-Modified", this.lastModified);
        }
        res.setContentType(this.contentType);
        if (this.characterEncoding != null) {
            res.setCharacterEncoding(this.characterEncoding);
        }
        res.setContentLength(this.data.length);
        res.getOutputStream().write(this.data);
    }
}

