/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.AccountInfo;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.ReviewerInfo;
import com.google.gerrit.common.data.SuggestService;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.httpd.rpc.BaseServiceImplementation;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountControl;
import com.google.gerrit.server.account.AccountVisibility;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupMembers;
import com.google.gerrit.server.change.PostReviewers;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gwtjsonrpc.common.AsyncCallback;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.Config;

class SuggestServiceImpl
extends BaseServiceImplementation
implements SuggestService {
    private static final String MAX_SUFFIX = "\u9fa5";
    private final Provider<ReviewDb> reviewDbProvider;
    private final AccountCache accountCache;
    private final GroupMembers.Factory groupMembersFactory;
    private final IdentifiedUser.GenericFactory identifiedUserFactory;
    private final AccountControl.Factory accountControlFactory;
    private final ChangeControl.Factory changeControlFactory;
    private final ProjectControl.Factory projectControlFactory;
    private final Config cfg;
    private final GroupBackend groupBackend;
    private final boolean suggestAccounts;

    @Inject
    SuggestServiceImpl(Provider<ReviewDb> schema, AccountCache accountCache, GroupMembers.Factory groupMembersFactory, Provider<CurrentUser> currentUser, IdentifiedUser.GenericFactory identifiedUserFactory, AccountControl.Factory accountControlFactory, ChangeControl.Factory changeControlFactory, ProjectControl.Factory projectControlFactory, @GerritServerConfig Config cfg, GroupBackend groupBackend) {
        super(schema, currentUser);
        this.reviewDbProvider = schema;
        this.accountCache = accountCache;
        this.groupMembersFactory = groupMembersFactory;
        this.identifiedUserFactory = identifiedUserFactory;
        this.accountControlFactory = accountControlFactory;
        this.changeControlFactory = changeControlFactory;
        this.projectControlFactory = projectControlFactory;
        this.cfg = cfg;
        this.groupBackend = groupBackend;
        if ("OFF".equals(cfg.getString("suggest", null, "accounts"))) {
            this.suggestAccounts = false;
        } else {
            boolean suggestAccounts;
            try {
                AccountVisibility av = cfg.getEnum("suggest", null, "accounts", AccountVisibility.ALL);
                suggestAccounts = av != AccountVisibility.NONE;
            }
            catch (IllegalArgumentException err) {
                suggestAccounts = cfg.getBoolean("suggest", null, "accounts", true);
            }
            this.suggestAccounts = suggestAccounts;
        }
    }

    @Override
    public void suggestAccount(final String query, final Boolean active, final int limit, AsyncCallback<List<AccountInfo>> callback) {
        this.run(callback, new BaseServiceImplementation.Action<List<AccountInfo>>(){

            @Override
            public List<AccountInfo> run(ReviewDb db) throws OrmException {
                return SuggestServiceImpl.this.suggestAccount(db, query, active, limit, new VisibilityControl(){

                    @Override
                    public boolean isVisible(Account account) throws OrmException {
                        return SuggestServiceImpl.this.accountControlFactory.get().canSee(account);
                    }
                });
            }
        });
    }

    private List<AccountInfo> suggestAccount(ReviewDb db, String query, Boolean active, int limit, VisibilityControl visibilityControl) throws OrmException {
        if (!this.suggestAccounts) {
            return Collections.emptyList();
        }
        String a = query;
        String b = a + MAX_SUFFIX;
        int max = 10;
        int n = limit <= 0 ? 10 : Math.min(limit, 10);
        LinkedHashMap<Account.Id, AccountInfo> r = new LinkedHashMap<Account.Id, AccountInfo>();
        for (Account p : db.accounts().suggestByFullName(a, b, n)) {
            this.addSuggestion(r, p, new AccountInfo(p), active, visibilityControl);
        }
        if (r.size() < n) {
            for (Account p : db.accounts().suggestByPreferredEmail(a, b, n - r.size())) {
                this.addSuggestion(r, p, new AccountInfo(p), active, visibilityControl);
            }
        }
        if (r.size() < n) {
            for (AccountExternalId e : db.accountExternalIds().suggestByEmailAddress(a, b, n - r.size())) {
                if (r.containsKey(e.getAccountId())) continue;
                Account p = this.accountCache.get(e.getAccountId()).getAccount();
                AccountInfo info = new AccountInfo(p);
                info.setPreferredEmail(e.getEmailAddress());
                this.addSuggestion(r, p, info, active, visibilityControl);
            }
        }
        return new ArrayList<AccountInfo>(r.values());
    }

    private void addSuggestion(Map<Account.Id, AccountInfo> map, Account account, AccountInfo info, Boolean active, VisibilityControl visibilityControl) throws OrmException {
        if (map.containsKey(account.getId())) {
            return;
        }
        if (active != null && active.booleanValue() != account.isActive()) {
            return;
        }
        if (visibilityControl.isVisible(account)) {
            map.put(account.getId(), info);
        }
    }

    @Override
    public void suggestAccountGroup(String query, int limit, AsyncCallback<List<GroupReference>> callback) {
        this.suggestAccountGroupForProject(null, query, limit, callback);
    }

    @Override
    public void suggestAccountGroupForProject(final Project.NameKey project, final String query, final int limit, AsyncCallback<List<GroupReference>> callback) {
        this.run(callback, new BaseServiceImplementation.Action<List<GroupReference>>(){

            @Override
            public List<GroupReference> run(ReviewDb db) {
                ProjectControl projectControl = null;
                if (project != null) {
                    try {
                        projectControl = SuggestServiceImpl.this.projectControlFactory.controlFor(project);
                    }
                    catch (NoSuchProjectException e) {
                        return Collections.emptyList();
                    }
                }
                return SuggestServiceImpl.this.suggestAccountGroup(projectControl, query, limit);
            }
        });
    }

    private List<GroupReference> suggestAccountGroup(@Nullable ProjectControl projectControl, String query, int limit) {
        return Lists.newArrayList(Iterables.limit(this.groupBackend.suggest(query, projectControl), limit <= 0 ? 10 : Math.min(limit, 10)));
    }

    @Override
    public void suggestReviewer(Project.NameKey project, String query, int limit, AsyncCallback<List<ReviewerInfo>> callback) {
        callback.onSuccess(Collections.emptyList());
    }

    @Override
    public void suggestChangeReviewer(final Change.Id change, final String query, final int limit, AsyncCallback<List<ReviewerInfo>> callback) {
        this.run(callback, new BaseServiceImplementation.Action<List<ReviewerInfo>>(){

            @Override
            public List<ReviewerInfo> run(ReviewDb db) throws OrmException, BaseServiceImplementation.Failure {
                ChangeControl changeControl;
                try {
                    changeControl = SuggestServiceImpl.this.changeControlFactory.controlFor(change);
                }
                catch (NoSuchChangeException e) {
                    return Collections.emptyList();
                }
                VisibilityControl visibilityControl = changeControl.getRefControl().isVisibleByRegisteredUsers() ? new VisibilityControl(){

                    @Override
                    public boolean isVisible(Account account) throws OrmException {
                        return true;
                    }
                } : new VisibilityControl(){

                    @Override
                    public boolean isVisible(Account account) throws OrmException {
                        IdentifiedUser who = SuggestServiceImpl.this.identifiedUserFactory.create(SuggestServiceImpl.this.reviewDbProvider, account.getId());
                        return changeControl.forUser(who).isRefVisible();
                    }
                };
                List suggestedAccounts = SuggestServiceImpl.this.suggestAccount(db, query, Boolean.TRUE, limit, visibilityControl);
                ArrayList<ReviewerInfo> reviewer = new ArrayList<ReviewerInfo>(suggestedAccounts.size());
                for (AccountInfo a : suggestedAccounts) {
                    reviewer.add(new ReviewerInfo(a));
                }
                List suggestedAccountGroups = SuggestServiceImpl.this.suggestAccountGroup(changeControl.getProjectControl(), query, limit);
                for (GroupReference g : suggestedAccountGroups) {
                    if (!SuggestServiceImpl.this.suggestGroupAsReviewer(changeControl.getProject().getNameKey(), g)) continue;
                    reviewer.add(new ReviewerInfo(g));
                }
                Collections.sort(reviewer);
                if (reviewer.size() <= limit) {
                    return reviewer;
                }
                return reviewer.subList(0, limit);
            }
        });
    }

    private boolean suggestGroupAsReviewer(Project.NameKey project, GroupReference group) throws OrmException, BaseServiceImplementation.Failure {
        if (!PostReviewers.isLegalReviewerGroup(group.getUUID())) {
            return false;
        }
        try {
            Set<Account> members = this.groupMembersFactory.create(this.getCurrentUser()).listAccounts(group.getUUID(), project);
            if (members.isEmpty()) {
                return false;
            }
            int maxAllowed = this.cfg.getInt("addreviewer", "maxAllowed", 20);
            if (maxAllowed > 0 && members.size() > maxAllowed) {
                return false;
            }
        }
        catch (NoSuchGroupException e) {
            return false;
        }
        catch (NoSuchProjectException e) {
            return false;
        }
        catch (IOException e) {
            throw new BaseServiceImplementation.Failure(e);
        }
        return true;
    }

    private static interface VisibilityControl {
        public boolean isVisible(Account var1) throws OrmException;
    }
}

