/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc.project;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.ProjectAccess;
import com.google.gerrit.httpd.rpc.project.ProjectAccessFactory;
import com.google.gerrit.httpd.rpc.project.ProjectAccessHandler;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.config.AllProjectsNameProvider;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.SetParent;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;

class ChangeProjectAccess
extends ProjectAccessHandler<ProjectAccess> {
    private final ProjectAccessFactory.Factory projectAccessFactory;
    private final ProjectCache projectCache;

    @Inject
    ChangeProjectAccess(ProjectAccessFactory.Factory projectAccessFactory, ProjectControl.Factory projectControlFactory, ProjectCache projectCache, GroupBackend groupBackend, MetaDataUpdate.User metaDataUpdateFactory, AllProjectsNameProvider allProjects, Provider<SetParent> setParent, @Assisted(value="projectName") Project.NameKey projectName, @Nullable @Assisted ObjectId base, @Assisted List<AccessSection> sectionList, @Nullable @Assisted(value="parentProjectName") Project.NameKey parentProjectName, @Nullable @Assisted String message) {
        super(projectControlFactory, groupBackend, metaDataUpdateFactory, allProjects, setParent, projectName, base, sectionList, parentProjectName, message, true);
        this.projectAccessFactory = projectAccessFactory;
        this.projectCache = projectCache;
    }

    @Override
    protected ProjectAccess updateProjectConfig(ProjectConfig config, MetaDataUpdate md, boolean parentProjectUpdate) throws IOException, NoSuchProjectException, ConfigInvalidException {
        config.commit(md);
        this.projectCache.evict(config.getProject());
        return this.projectAccessFactory.create(this.projectName).call();
    }

    static interface Factory {
        public ChangeProjectAccess create(@Assisted(value="projectName") Project.NameKey var1, @Nullable @Assisted ObjectId var2, @Assisted List<AccessSection> var3, @Nullable @Assisted(value="parentProjectName") Project.NameKey var4, @Nullable @Assisted String var5);
    }
}

