/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc.project;

import com.google.gerrit.common.ChangeHooks;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.extensions.api.changes.AddReviewerInput;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.httpd.rpc.project.ProjectAccessHandler;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetAncestor;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.ChangesCollection;
import com.google.gerrit.server.change.MergeabilityChecker;
import com.google.gerrit.server.change.PostReviewers;
import com.google.gerrit.server.config.AllProjectsNameProvider;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.mail.CreateChangeSender;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.SetParent;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReviewProjectAccess
extends ProjectAccessHandler<Change.Id> {
    private static final Logger log = LoggerFactory.getLogger(ReviewProjectAccess.class);
    private final ReviewDb db;
    private final IdentifiedUser user;
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final Provider<PostReviewers> reviewersProvider;
    private final MergeabilityChecker mergeabilityChecker;
    private final ChangeHooks hooks;
    private final CreateChangeSender.Factory createChangeSenderFactory;
    private final ProjectCache projectCache;
    private final ChangesCollection changes;

    @Inject
    ReviewProjectAccess(ProjectControl.Factory projectControlFactory, GroupBackend groupBackend, MetaDataUpdate.User metaDataUpdateFactory, ReviewDb db, IdentifiedUser user, PatchSetInfoFactory patchSetInfoFactory, Provider<PostReviewers> reviewersProvider, MergeabilityChecker mergeabilityChecker, ChangeHooks hooks, CreateChangeSender.Factory createChangeSenderFactory, ProjectCache projectCache, AllProjectsNameProvider allProjects, ChangesCollection changes, Provider<SetParent> setParent, @Assisted(value="projectName") Project.NameKey projectName, @Nullable @Assisted ObjectId base, @Assisted List<AccessSection> sectionList, @Nullable @Assisted(value="parentProjectName") Project.NameKey parentProjectName, @Nullable @Assisted String message) {
        super(projectControlFactory, groupBackend, metaDataUpdateFactory, allProjects, setParent, projectName, base, sectionList, parentProjectName, message, false);
        this.db = db;
        this.user = user;
        this.patchSetInfoFactory = patchSetInfoFactory;
        this.reviewersProvider = reviewersProvider;
        this.mergeabilityChecker = mergeabilityChecker;
        this.hooks = hooks;
        this.createChangeSenderFactory = createChangeSenderFactory;
        this.projectCache = projectCache;
        this.changes = changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Change.Id updateProjectConfig(ProjectConfig config, MetaDataUpdate md, boolean parentProjectUpdate) throws IOException, OrmException {
        ChangeResource rsrc;
        Change.Id changeId = new Change.Id(this.db.nextChangeId());
        PatchSet ps = new PatchSet(new PatchSet.Id(changeId, 1));
        RevCommit commit = config.commitToNewRef(md, ps.getRefName());
        if (commit.getId().equals(this.base)) {
            return null;
        }
        Change change = new Change(new Change.Key("I" + commit.name()), changeId, this.user.getAccountId(), new Branch.NameKey(config.getProject().getNameKey(), "refs/meta/config"), TimeUtil.nowTs());
        ps.setCreatedOn(change.getCreatedOn());
        ps.setUploader(change.getOwner());
        ps.setRevision(new RevId(commit.name()));
        PatchSetInfo info = this.patchSetInfoFactory.get(commit, ps.getId());
        change.setCurrentPatchSet(info);
        ChangeUtil.updated(change);
        this.db.changes().beginTransaction(changeId);
        try {
            this.insertAncestors(ps.getId(), commit);
            this.db.patchSets().insert(Collections.singleton(ps));
            this.db.changes().insert(Collections.singleton(change));
            this.db.commit();
        }
        finally {
            this.db.rollback();
        }
        this.mergeabilityChecker.updateAndIndexAsync(change).checkedGet();
        this.hooks.doPatchsetCreatedHook(change, ps, this.db);
        try {
            CreateChangeSender cm = this.createChangeSenderFactory.create(change);
            cm.setFrom(change.getOwner());
            cm.setPatchSet(ps, info);
            cm.send();
        }
        catch (Exception err) {
            log.error("Cannot send email for new change " + change.getId(), err);
        }
        try {
            rsrc = this.changes.parse(changeId);
        }
        catch (ResourceNotFoundException e) {
            throw new IOException(e);
        }
        this.addProjectOwnersAsReviewers(rsrc);
        if (parentProjectUpdate) {
            this.addAdministratorsAsReviewers(rsrc);
        }
        return changeId;
    }

    private void insertAncestors(PatchSet.Id id, RevCommit src) throws OrmException {
        int cnt = src.getParentCount();
        ArrayList<PatchSetAncestor> toInsert = new ArrayList<PatchSetAncestor>(cnt);
        for (int p = 0; p < cnt; ++p) {
            PatchSetAncestor a = new PatchSetAncestor(new PatchSetAncestor.Id(id, p + 1));
            a.setAncestorRevision(new RevId(src.getParent(p).name()));
            toInsert.add(a);
        }
        this.db.patchSetAncestors().insert(toInsert);
    }

    private void addProjectOwnersAsReviewers(ChangeResource rsrc) {
        String projectOwners = this.groupBackend.get(SystemGroupBackend.PROJECT_OWNERS).getName();
        try {
            AddReviewerInput input = new AddReviewerInput();
            input.reviewer = projectOwners;
            this.reviewersProvider.get().apply(rsrc, input);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addAdministratorsAsReviewers(ChangeResource rsrc) {
        List<PermissionRule> adminRules = this.projectCache.getAllProjects().getConfig().getAccessSection("GLOBAL_CAPABILITIES").getPermission("administrateServer").getRules();
        for (PermissionRule r : adminRules) {
            try {
                AddReviewerInput input = new AddReviewerInput();
                input.reviewer = r.getGroup().getUUID().get();
                this.reviewersProvider.get().apply(rsrc, input);
            }
            catch (Exception e) {}
        }
    }

    static interface Factory {
        public ReviewProjectAccess create(@Assisted(value="projectName") Project.NameKey var1, @Nullable @Assisted ObjectId var2, @Assisted List<AccessSection> var3, @Nullable @Assisted(value="parentProjectName") Project.NameKey var4, @Nullable @Assisted String var5);
    }
}

