/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.CompoundKey;
import com.google.gwtorm.client.StringKey;
import java.sql.Timestamp;
import java.util.Objects;

public final class PatchSetApproval {
    @Column(id=1, name="--NONE--")
    protected Key key;
    @Column(id=2)
    protected short value;
    @Column(id=3)
    protected Timestamp granted;

    protected PatchSetApproval() {
    }

    public PatchSetApproval(Key k, short v, Timestamp ts) {
        this.key = k;
        this.setValue(v);
        this.setGranted(ts);
    }

    public PatchSetApproval(PatchSet.Id psId, PatchSetApproval src) {
        this.key = new Key(psId, src.getAccountId(), src.getLabelId());
        this.value = src.getValue();
        this.granted = src.granted;
    }

    public Key getKey() {
        return this.key;
    }

    public PatchSet.Id getPatchSetId() {
        return this.key.patchSetId;
    }

    public Account.Id getAccountId() {
        return this.key.accountId;
    }

    public LabelId getLabelId() {
        return this.key.categoryId;
    }

    public short getValue() {
        return this.value;
    }

    public void setValue(short v) {
        this.value = v;
    }

    public Timestamp getGranted() {
        return this.granted;
    }

    public void setGranted(Timestamp ts) {
        this.granted = ts;
    }

    public String getLabel() {
        return this.getLabelId().get();
    }

    public boolean isSubmit() {
        return LabelId.SUBMIT.get().equals(this.getLabel());
    }

    public String toString() {
        return "" + '[' + this.key + ": " + this.value + ']';
    }

    public boolean equals(Object o) {
        if (o instanceof PatchSetApproval) {
            PatchSetApproval p = (PatchSetApproval)o;
            return Objects.equals(this.key, p.key) && Objects.equals(this.value, p.value) && Objects.equals(this.granted, p.granted);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.granted);
    }

    public static class Key
    extends CompoundKey<PatchSet.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1, name="--NONE--")
        protected PatchSet.Id patchSetId;
        @Column(id=2)
        protected Account.Id accountId;
        @Column(id=3)
        protected LabelId categoryId;

        protected Key() {
            this.patchSetId = new PatchSet.Id();
            this.accountId = new Account.Id();
            this.categoryId = new LabelId();
        }

        public Key(PatchSet.Id ps, Account.Id a, LabelId c) {
            this.patchSetId = ps;
            this.accountId = a;
            this.categoryId = c;
        }

        @Override
        public PatchSet.Id getParentKey() {
            return this.patchSetId;
        }

        public Account.Id getAccountId() {
            return this.accountId;
        }

        public LabelId getLabelId() {
            return this.categoryId;
        }

        @Override
        public com.google.gwtorm.client.Key<?>[] members() {
            return new com.google.gwtorm.client.Key[]{this.accountId, this.categoryId};
        }
    }

    public static class LabelId
    extends StringKey<com.google.gwtorm.client.Key<?>> {
        private static final long serialVersionUID = 1L;
        public static final LabelId SUBMIT = new LabelId("SUBM");
        @Column(id=1)
        protected String id;

        protected LabelId() {
        }

        public LabelId(String n) {
            this.id = n;
        }

        @Override
        public String get() {
            return this.id;
        }

        @Override
        protected void set(String newValue) {
            this.id = newValue;
        }

        @Override
        public int hashCode() {
            return this.get().hashCode();
        }

        @Override
        public boolean equals(Object b) {
            if (b instanceof LabelId) {
                return this.get().equals(((LabelId)b).get());
            }
            return false;
        }
    }
}

