/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.rules.PredicateClassLoader;
import com.google.gerrit.rules.PredicateProvider;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.googlecode.prolog_cafe.compiler.CompileException;
import com.googlecode.prolog_cafe.lang.BufferingPrologControl;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.PrologClassLoader;
import com.googlecode.prolog_cafe.lang.PrologMachineCopy;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.RawParseUtils;

@Singleton
public class RulesCache {
    private static final int SRC_LIMIT = 131072;
    private static final int DB_MAX = 256;
    private static final List<String> PACKAGE_LIST = ImmutableList.of("com.googlecode.prolog_cafe.builtin", "gerrit");
    private final Map<ObjectId, MachineRef> machineCache = new HashMap<ObjectId, MachineRef>();
    private final ReferenceQueue<PrologMachineCopy> dead = new ReferenceQueue();
    private final boolean enableProjectRules;
    private final File cacheDir;
    private final File rulesDir;
    private final GitRepositoryManager gitMgr;
    private final DynamicSet<PredicateProvider> predicateProviders;
    private final ClassLoader systemLoader;
    private final PrologMachineCopy defaultMachine;

    @Inject
    protected RulesCache(@GerritServerConfig Config config, SitePaths site, GitRepositoryManager gm, DynamicSet<PredicateProvider> predicateProviders) {
        this.enableProjectRules = config.getBoolean("rules", null, "enable", true);
        this.cacheDir = site.resolve(config.getString("cache", null, "directory"));
        this.rulesDir = this.cacheDir != null ? new File(this.cacheDir, "rules") : null;
        this.gitMgr = gm;
        this.predicateProviders = predicateProviders;
        this.systemLoader = this.getClass().getClassLoader();
        this.defaultMachine = PrologMachineCopy.save(this.newEmptyMachine(this.systemLoader));
    }

    public boolean isProjectRulesEnabled() {
        return this.enableProjectRules;
    }

    public synchronized PrologMachineCopy loadMachine(Project.NameKey project, ObjectId rulesId) throws CompileException {
        if (!this.enableProjectRules || project == null || rulesId == null) {
            return this.defaultMachine;
        }
        Reference ref = this.machineCache.get(rulesId);
        if (ref != null) {
            PrologMachineCopy pmc = (PrologMachineCopy)ref.get();
            if (pmc != null) {
                return pmc;
            }
            this.machineCache.remove(rulesId);
            ref.enqueue();
        }
        this.gc();
        PrologMachineCopy pcm = this.createMachine(project, rulesId);
        MachineRef newRef = new MachineRef(rulesId, pcm, this.dead);
        this.machineCache.put(rulesId, newRef);
        return pcm;
    }

    public PrologMachineCopy loadMachine(String name, InputStream in) throws CompileException {
        PrologMachineCopy pmc = this.consultRules(name, new InputStreamReader(in));
        if (pmc == null) {
            throw new CompileException("Cannot consult rules from the stream " + name);
        }
        return pmc;
    }

    private void gc() {
        Reference<PrologMachineCopy> ref;
        while ((ref = this.dead.poll()) != null) {
            ObjectId key = ((MachineRef)ref).key;
            if (this.machineCache.get(key) != ref) continue;
            this.machineCache.remove(key);
        }
    }

    private PrologMachineCopy createMachine(Project.NameKey project, ObjectId rulesId) throws CompileException {
        File jarFile;
        if (this.rulesDir != null && (jarFile = new File(this.rulesDir, "rules-" + rulesId.getName() + ".jar")).isFile()) {
            URL[] cp = new URL[]{RulesCache.toURL(jarFile)};
            return PrologMachineCopy.save(this.newEmptyMachine(new URLClassLoader(cp, this.systemLoader)));
        }
        String rules = this.read(project, rulesId);
        PrologMachineCopy pmc = this.consultRules("rules.pl", new StringReader(rules));
        if (pmc == null) {
            throw new CompileException("Cannot consult rules of " + project);
        }
        return pmc;
    }

    private PrologMachineCopy consultRules(String name, Reader rules) {
        BufferingPrologControl ctl = this.newEmptyMachine(this.systemLoader);
        PushbackReader in = new PushbackReader(rules, 3);
        if (!ctl.execute("com.googlecode.prolog_cafe.builtin", "consult_stream", SymbolTerm.intern(name), new JavaObjectTerm(in))) {
            return null;
        }
        return PrologMachineCopy.save(ctl);
    }

    private String read(Project.NameKey project, ObjectId rulesId) throws CompileException {
        Repository git;
        try {
            git = this.gitMgr.openRepository(project);
        }
        catch (RepositoryNotFoundException e) {
            throw new CompileException("Cannot open repository " + project, e);
        }
        catch (IOException e) {
            throw new CompileException("Cannot open repository " + project, e);
        }
        try {
            ObjectLoader ldr = git.open(rulesId, 3);
            byte[] raw = ldr.getCachedBytes(131072);
            String string = RawParseUtils.decode(raw);
            return string;
        }
        catch (LargeObjectException e) {
            throw new CompileException("rules of " + project + " are too large", e);
        }
        catch (RuntimeException e) {
            throw new CompileException("Cannot load rules of " + project, e);
        }
        catch (IOException e) {
            throw new CompileException("Cannot load rules of " + project, e);
        }
        finally {
            git.close();
        }
    }

    private BufferingPrologControl newEmptyMachine(ClassLoader cl) {
        BufferingPrologControl ctl = new BufferingPrologControl();
        ctl.setMaxArity(8);
        ctl.setMaxDatabaseSize(256);
        ctl.setPrologClassLoader(new PrologClassLoader(new PredicateClassLoader(this.predicateProviders, cl)));
        ctl.setEnabled(EnumSet.allOf(Prolog.Feature.class), false);
        ArrayList<String> packages = Lists.newArrayList();
        packages.addAll(PACKAGE_LIST);
        for (PredicateProvider predicateProvider : this.predicateProviders) {
            packages.addAll(predicateProvider.getPackages());
        }
        ctl.initialize(packages.toArray(new String[packages.size()]));
        return ctl;
    }

    private static URL toURL(File jarFile) throws CompileException {
        try {
            return jarFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new CompileException("Cannot create URL for " + jarFile, e);
        }
    }

    private static final class MachineRef
    extends WeakReference<PrologMachineCopy> {
        final ObjectId key;

        MachineRef(ObjectId key, PrologMachineCopy pcm, ReferenceQueue<PrologMachineCopy> queue) {
            super(pcm, queue);
            this.key = key;
        }
    }
}

