/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.collect.ImmutableMap;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.detector.MimeDetector;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;

public class DefaultFileExtensionRegistry
extends MimeDetector {
    private static final MimeType INI = DefaultFileExtensionRegistry.newMimeType("text/x-ini", 2);
    private static final MimeType PYTHON = DefaultFileExtensionRegistry.newMimeType("text/x-python", 2);
    private static final MimeType PERL = DefaultFileExtensionRegistry.newMimeType("text/x-perl", 2);
    private static final MimeType LISP = DefaultFileExtensionRegistry.newMimeType("text/x-common-lisp", 2);
    private static final ImmutableMap<String, MimeType> TYPES = ImmutableMap.builder().put(".gitmodules", INI).put("project.config", INI).put("BUCK", PYTHON).put("bucklet", DefaultFileExtensionRegistry.newMimeType(PYTHON.toString(), 1)).put("defs", DefaultFileExtensionRegistry.newMimeType(PYTHON.toString(), 1)).put("py", DefaultFileExtensionRegistry.newMimeType(PYTHON.toString(), 1)).put("go", DefaultFileExtensionRegistry.newMimeType("text/x-go", 1)).put("cxx", DefaultFileExtensionRegistry.newMimeType("text/x-c++src", 1)).put("hxx", DefaultFileExtensionRegistry.newMimeType("text/x-c++hdr", 1)).put("scala", DefaultFileExtensionRegistry.newMimeType("text/x-scala", 1)).put("pl", PERL).put("pm", PERL).put("rb", DefaultFileExtensionRegistry.newMimeType("text/x-ruby", 2)).put("cl", LISP).put("el", LISP).put("lisp", LISP).put("lsp", LISP).put("clj", DefaultFileExtensionRegistry.newMimeType("text/x-clojure", 2)).put("groovy", DefaultFileExtensionRegistry.newMimeType("text/x-groovy", 2)).build();

    private static MimeType newMimeType(String type, final int specificity) {
        return new MimeType(type){
            private static final long serialVersionUID = 1L;

            @Override
            public int getSpecificity() {
                return specificity;
            }
        };
    }

    @Override
    public String getDescription() {
        return this.getClass().getName();
    }

    @Override
    protected Collection<MimeType> getMimeTypesFileName(String name) {
        MimeType type;
        int s = name.lastIndexOf(47);
        if (s >= 0) {
            name = name.substring(s + 1);
        }
        if ((type = TYPES.get(name)) != null) {
            return Collections.singletonList(type);
        }
        int d = name.lastIndexOf(46);
        if (0 < d && (type = TYPES.get(name.substring(d + 1))) != null) {
            return Collections.singletonList(type);
        }
        return Collections.emptyList();
    }

    @Override
    protected Collection<MimeType> getMimeTypesFile(File file) {
        return this.getMimeTypesFileName(file.getName());
    }

    @Override
    protected Collection<MimeType> getMimeTypesURL(URL url) {
        return this.getMimeTypesFileName(url.getPath());
    }

    @Override
    protected Collection<MimeType> getMimeTypesInputStream(InputStream arg0) {
        return Collections.emptyList();
    }

    @Override
    protected Collection<MimeType> getMimeTypesByteArray(byte[] arg0) {
        return Collections.emptyList();
    }

    static {
        for (MimeType type : TYPES.values()) {
            MimeUtil.addKnownMimeType(type);
        }
    }
}

